/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.alarms.preferencepages;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.server.ServerFile;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.login.LoginJob;
import org.netxms.nxmc.base.propertypages.PropertyPage;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.resources.SharedIcons;
import org.netxms.nxmc.resources.StatusDisplayInfo;
import org.netxms.nxmc.tools.WidgetHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

/*
 * Exception performing whole class analysis ignored.
 */
public class AlarmSounds
extends PropertyPage {
    private final I18n i18n = LocalizationHelper.getI18n(AlarmSounds.class);
    private static Logger logger = LoggerFactory.getLogger(LoginJob.class);
    private NXCSession session;
    private ServerFile[] serverFiles = null;
    private File workspaceDir;
    private Button isGeneralSound;
    private Button isLocalSound;
    private PreferenceStore ps;
    private Set<String> soundList = new HashSet();
    private List<String> currentSoundList = new ArrayList();
    private Set<String> oldSoundList = new HashSet();
    private List<String> newSoundList = new ArrayList();
    private List<Combo> comboList = new ArrayList();
    private List<Button> buttonList = new ArrayList();

    public AlarmSounds() {
        super(LocalizationHelper.getI18n(AlarmSounds.class).tr("Alarm sounds"));
        this.workspaceDir = Registry.getStateDir();
        this.ps = PreferenceStore.getInstance();
        this.setPreferenceStore((IPreferenceStore)this.ps);
        this.session = Registry.getSession();
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 5;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        Group typeGroup = new Group(dialogArea, 0);
        layout = new GridLayout();
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 5;
        layout.numColumns = 2;
        typeGroup.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        typeGroup.setLayoutData((Object)gd);
        this.isGeneralSound = new Button((Composite)typeGroup, 16);
        this.isGeneralSound.setText("Play sound on all alarms");
        this.isGeneralSound.setLayoutData((Object)new GridData());
        this.isGeneralSound.setSelection(!this.ps.getAsBoolean("AlarmNotifier.LocalSound", false));
        this.isLocalSound = new Button((Composite)typeGroup, 16);
        this.isLocalSound.setText("Play sound as defined by active dashboard");
        this.isLocalSound.setLayoutData((Object)new GridData());
        this.isLocalSound.setSelection(this.ps.getAsBoolean("AlarmNotifier.LocalSound", false));
        Combo newCombo = null;
        Button button = null;
        for (int i = 0; i < 6; ++i) {
            String soundId = i < 5 ? StatusDisplayInfo.getStatusText((int)i) : "Outstanding alarm reminder";
            newCombo = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)12, (String)soundId, (Object)"WidgetHelper::default_layout_data");
            newCombo.setEnabled(false);
            this.comboList.add(i, newCombo);
            button = new Button(dialogArea, 8);
            GridData gridData = new GridData();
            gridData.verticalAlignment = 3;
            button.setLayoutData((Object)gridData);
            button.setImage(SharedIcons.IMG_SOUND);
            int index = i;
            button.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
            this.buttonList.add(i, button);
        }
        this.getShell().getDisplay().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        return dialogArea;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getMelodyAndDownloadIfRequired(String melodyName) {
        block10: {
            if (!AlarmSounds.isSoundFileExist((String)melodyName, (File)this.workspaceDir)) {
                try {
                    File fileContent = this.session.downloadFileFromServer(melodyName);
                    if (fileContent == null) break block10;
                    FileInputStream src = null;
                    FileOutputStream dest = null;
                    try {
                        src = new FileInputStream(fileContent);
                        File f = new File(this.workspaceDir.getPath(), melodyName);
                        f.createNewFile();
                        dest = new FileOutputStream(f);
                        FileChannel fcSrc = src.getChannel();
                        dest.getChannel().transferFrom(fcSrc, 0L, fcSrc.size());
                    }
                    catch (IOException e) {
                        logger.error("Cannot copy sound file", (Throwable)e);
                    }
                    finally {
                        if (src != null) {
                            src.close();
                        }
                        if (dest != null) {
                            dest.close();
                        }
                    }
                }
                catch (Exception e) {
                    Display.getDefault().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
                }
            }
        }
    }

    private static boolean isSoundFileExist(String melodyName, File workspaceDir2) {
        if (!melodyName.isEmpty() && workspaceDir2 != null) {
            File f = new File(workspaceDir2.getPath(), melodyName);
            return f.isFile();
        }
        return true;
    }

    protected boolean applyChanges(boolean isApply) {
        if (isApply) {
            this.setValid(false);
        }
        this.newSoundList.clear();
        for (int i = 0; i < this.comboList.size(); ++i) {
            this.newSoundList.add(((Combo)this.comboList.get(i)).getText());
        }
        boolean newSelection = this.isGeneralSound.getSelection();
        this.getShell().getDisplay().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        return true;
    }

    private void changeSound(String soundName, String severity, int id) {
        String oldSoundName = (String)this.currentSoundList.get(id);
        if (!soundName.equals(oldSoundName)) {
            try {
                if (!AlarmSounds.checkMelodyExists((String)soundName, (File)this.workspaceDir)) {
                    AlarmSounds.downloadSoundFile((NXCSession)this.session, (String)soundName, (File)this.workspaceDir);
                }
                this.ps.set("AlarmNotifier.Sound." + severity, soundName);
                this.currentSoundList.set(id, soundName);
                this.oldSoundList.add(oldSoundName);
            }
            catch (Exception e) {
                this.getShell().getDisplay().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
                this.ps.set("ALARM_NOTIFIER.MELODY." + severity, "");
            }
        }
    }

    private static boolean checkMelodyExists(String melodyName, File workspaceDir2) {
        if (workspaceDir2 != null && melodyName != null && !melodyName.equals("")) {
            File f = new File(workspaceDir2.getPath(), melodyName);
            return f.isFile();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void downloadSoundFile(NXCSession session, String melodyName, File workspaceDir2) throws NXCException, IOException {
        File serverFile = session.downloadFileFromServer(melodyName);
        FileChannel src = null;
        AbstractInterruptibleChannel dest = null;
        try {
            src = new FileInputStream(serverFile).getChannel();
            File f = new File(workspaceDir2.getPath(), melodyName);
            f.createNewFile();
            dest = new FileOutputStream(f).getChannel();
            ((FileChannel)dest).transferFrom(src, 0L, src.size());
        }
        catch (IOException e) {
            logger.error("Cannot copy sound file", (Throwable)e);
        }
        finally {
            if (src != null) {
                src.close();
            }
            if (dest != null) {
                dest.close();
            }
        }
    }
}

