/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.alarms.views;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.DataType;
import org.netxms.client.constants.Severity;
import org.netxms.client.datacollection.ChartConfiguration;
import org.netxms.client.datacollection.ChartDciConfig;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.datacollection.Threshold;
import org.netxms.client.events.Alarm;
import org.netxms.client.events.AlarmComment;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.Memento;
import org.netxms.nxmc.base.actions.CopyTableRowsAction;
import org.netxms.nxmc.base.layout.DashboardLayout;
import org.netxms.nxmc.base.layout.DashboardLayoutData;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.views.ViewNotRestoredException;
import org.netxms.nxmc.base.widgets.ImageHyperlink;
import org.netxms.nxmc.base.widgets.Section;
import org.netxms.nxmc.base.widgets.SortableTreeViewer;
import org.netxms.nxmc.base.widgets.events.HyperlinkAdapter;
import org.netxms.nxmc.base.widgets.events.IHyperlinkListener;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.alarms.dialogs.EditCommentDialog;
import org.netxms.nxmc.modules.alarms.views.AlarmDetails;
import org.netxms.nxmc.modules.alarms.views.helpers.EventTreeComparator;
import org.netxms.nxmc.modules.alarms.views.helpers.EventTreeContentProvider;
import org.netxms.nxmc.modules.alarms.views.helpers.EventTreeLabelProvider;
import org.netxms.nxmc.modules.alarms.widgets.AlarmCommentsEditor;
import org.netxms.nxmc.modules.charts.api.ChartType;
import org.netxms.nxmc.modules.charts.widgets.Chart;
import org.netxms.nxmc.modules.datacollection.views.helpers.HistoricalDataLabelProvider;
import org.netxms.nxmc.modules.objects.views.AdHocObjectView;
import org.netxms.nxmc.modules.objects.widgets.helpers.BaseObjectLabelProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.resources.SharedIcons;
import org.netxms.nxmc.resources.StatusDisplayInfo;
import org.netxms.nxmc.resources.ThemeEngine;
import org.netxms.nxmc.tools.ColorConverter;
import org.netxms.nxmc.tools.ImageCache;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.ViewRefreshController;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class AlarmDetails
extends AdHocObjectView {
    private final I18n i18n = LocalizationHelper.getI18n(AlarmDetails.class);
    public static final String ID = "AlarmDetails";
    public static final int EV_COLUMN_SEVERITY = 0;
    public static final int EV_COLUMN_SOURCE = 1;
    public static final int EV_COLUMN_NAME = 2;
    public static final int EV_COLUMN_MESSAGE = 3;
    public static final int EV_COLUMN_TIMESTAMP = 4;
    private static final String[] stateText = new String[]{LocalizationHelper.getI18n(AlarmDetails.class).tr("Outstanding"), LocalizationHelper.getI18n(AlarmDetails.class).tr("Acknowledged"), LocalizationHelper.getI18n(AlarmDetails.class).tr("Resolved"), LocalizationHelper.getI18n(AlarmDetails.class).tr("Terminated")};
    private long alarmId;
    private ImageCache imageCache;
    private BaseObjectLabelProvider objectLabelProvider;
    private Composite content;
    private CLabel alarmSeverity;
    private CLabel alarmState;
    private CLabel alarmSource;
    private Label alarmDCI;
    private CLabel alarmKey;
    private CLabel alarmRule;
    private Text alarmText;
    private ScrolledComposite editorsScroller;
    private Composite editorsArea;
    private ImageHyperlink linkAddComment;
    private Map<Long, AlarmCommentsEditor> editors = new HashMap();
    private Composite dataArea;
    private SortableTreeViewer eventViewer;
    private CLabel labelAccessDenied = null;
    private boolean dataSectionCreated = false;
    private boolean dataSectionPopulated = false;
    private Section dataSection;
    private Chart chart;
    private TableViewer dataViewer;
    private Control dataViewControl;
    private long nodeId;
    private long dciId;
    private ViewRefreshController refreshController = null;
    private boolean updateInProgress = false;
    private Image[] stateImages = new Image[5];
    private CopyTableRowsAction copyEvent;

    public AlarmDetails(long alarmId, long contextObject) {
        super(String.format(LocalizationHelper.getI18n(AlarmDetails.class).tr("Alarm Details [%d]"), alarmId), ResourceManager.getImageDescriptor((String)"icons/object-views/alarms.png"), "objects.alarm-details", contextObject, contextObject, false);
        this.alarmId = alarmId;
        this.objectLabelProvider = new BaseObjectLabelProvider();
        this.stateImages[0] = ResourceManager.getImage((String)"icons/alarms/outstanding.png");
        this.stateImages[1] = ResourceManager.getImage((String)"icons/alarms/acknowledged.png");
        this.stateImages[2] = ResourceManager.getImage((String)"icons/alarms/resolved.png");
        this.stateImages[3] = ResourceManager.getImage((String)"icons/alarms/terminated.png");
        this.stateImages[4] = ResourceManager.getImage((String)"icons/alarms/acknowledged_sticky.png");
    }

    protected AlarmDetails() {
        super(LocalizationHelper.getI18n(AlarmDetails.class).tr("Alarm Details"), ResourceManager.getImageDescriptor((String)"icons/object-views/alarms.png"), "objects.alarm-details", 0L, 0L, false);
        this.objectLabelProvider = new BaseObjectLabelProvider();
        this.stateImages[0] = ResourceManager.getImage((String)"icons/alarms/outstanding.png");
        this.stateImages[1] = ResourceManager.getImage((String)"icons/alarms/acknowledged.png");
        this.stateImages[2] = ResourceManager.getImage((String)"icons/alarms/resolved.png");
        this.stateImages[3] = ResourceManager.getImage((String)"icons/alarms/terminated.png");
        this.stateImages[4] = ResourceManager.getImage((String)"icons/alarms/acknowledged_sticky.png");
    }

    public View cloneView() {
        AlarmDetails view = (AlarmDetails)super.cloneView();
        view.alarmId = this.alarmId;
        return view;
    }

    protected void postClone(View origin) {
        super.postClone(origin);
        this.refresh();
    }

    protected void createContent(Composite parent) {
        this.imageCache = new ImageCache();
        this.content = parent;
        DashboardLayout layout = new DashboardLayout();
        layout.marginWidth = 4;
        layout.marginHeight = 4;
        parent.setLayout((Layout)layout);
        this.createAlarmDetailsSection(parent);
        this.createEventsSection(parent);
        this.createCommentsSection(parent);
        this.createDataSection(parent);
        this.createActions();
        this.createContextMenu();
    }

    private void createActions() {
        this.copyEvent = new CopyTableRowsAction((ColumnViewer)this.eventViewer, true);
    }

    protected void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.eventViewer.getControl());
        this.eventViewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.copyEvent);
    }

    protected void postContentCreate() {
        super.postContentCreate();
        this.refresh();
    }

    private void createAlarmDetailsSection(Composite parent) {
        Section section = new Section(parent, this.i18n.tr("Overview"), true);
        DashboardLayoutData dd = new DashboardLayoutData();
        dd.fill = false;
        section.setLayoutData((Object)dd);
        Composite clientArea = section.getClient();
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        clientArea.setLayout((Layout)layout);
        this.alarmSeverity = new CLabel(clientArea, 0);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 128;
        this.alarmSeverity.setLayoutData((Object)gd);
        Label sep = new Label(clientArea, 514);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.verticalSpan = 4;
        sep.setLayoutData((Object)gd);
        2 textContainer = new /* Unavailable Anonymous Inner Class!! */;
        textContainer.setExpandHorizontal(true);
        WidgetHelper.setScrollBarIncrement((Scrollable)textContainer, (int)256, (int)20);
        textContainer.setExpandVertical(true);
        WidgetHelper.setScrollBarIncrement((Scrollable)textContainer, (int)512, (int)20);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.verticalSpan = 4;
        textContainer.setLayoutData((Object)gd);
        textContainer.addControlListener((ControlListener)new /* Unavailable Anonymous Inner Class!! */);
        this.alarmText = new Text((Composite)textContainer, 2);
        this.alarmText.setEditable(false);
        this.alarmText.setBackground(clientArea.getBackground());
        textContainer.setContent((Control)this.alarmText);
        this.alarmState = new CLabel(clientArea, 0);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 128;
        this.alarmState.setLayoutData((Object)gd);
        this.alarmSource = new CLabel(clientArea, 0);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 128;
        this.alarmSource.setLayoutData((Object)gd);
        this.alarmKey = new CLabel(clientArea, 0);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 128;
        this.alarmKey.setLayoutData((Object)gd);
        Image keyImage = ResourceManager.getImageDescriptor((String)"icons/key.png").createImage();
        this.alarmKey.setImage(keyImage);
        this.alarmKey.addDisposeListener((DisposeListener & Serializable)e -> keyImage.dispose());
        this.alarmRule = new CLabel(clientArea, 0);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1024;
        gd.horizontalSpan = 3;
        this.alarmRule.setLayoutData((Object)gd);
        Image eppImage = ResourceManager.getImageDescriptor((String)"icons/epp.png").createImage();
        this.alarmRule.setImage(eppImage);
        this.alarmRule.addDisposeListener((DisposeListener & Serializable)e -> eppImage.dispose());
    }

    private void createCommentsSection(Composite parent) {
        Section section = new Section(parent, this.i18n.tr("Comments"), true);
        DashboardLayoutData dd = new DashboardLayoutData();
        dd.fill = true;
        section.setLayoutData((Object)dd);
        section.addExpansionListener(e -> {
            dd.fill = e.getState();
        });
        this.editorsScroller = new ScrolledComposite(section.getClient(), 512);
        this.editorsScroller.setBackground(section.getClient().getBackground());
        this.editorsScroller.setExpandHorizontal(true);
        this.editorsScroller.setExpandVertical(true);
        WidgetHelper.setScrollBarIncrement((Scrollable)this.editorsScroller, (int)512, (int)20);
        this.editorsScroller.addControlListener((ControlListener)new /* Unavailable Anonymous Inner Class!! */);
        this.editorsArea = new Composite((Composite)this.editorsScroller, 0);
        this.editorsArea.setBackground(section.getClient().getBackground());
        GridLayout layout = new GridLayout();
        this.editorsArea.setLayout((Layout)layout);
        this.editorsScroller.setContent((Control)this.editorsArea);
        this.linkAddComment = new ImageHyperlink(this.editorsArea, 0);
        this.linkAddComment.setImage(this.imageCache.create(ResourceManager.getImageDescriptor((String)"icons/new_comment.png")));
        this.linkAddComment.setText(this.i18n.tr("Add comment"));
        this.linkAddComment.setBackground(this.editorsArea.getBackground());
        this.linkAddComment.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void createEventsSection(Composite parent) {
        Section section = new Section(parent, this.i18n.tr("Related Events"), true);
        DashboardLayoutData dd = new DashboardLayoutData();
        dd.fill = true;
        section.setLayoutData((Object)dd);
        section.addExpansionListener(e -> {
            dd.fill = e.getState();
        });
        String[] names = new String[]{this.i18n.tr("Severity"), this.i18n.tr("Source"), this.i18n.tr("Name"), this.i18n.tr("Message"), this.i18n.tr("Timestamp")};
        int[] widths = new int[]{130, 160, 160, 400, 150};
        this.eventViewer = new SortableTreeViewer(section.getClient(), names, widths, 4, 1024, 65536);
        this.eventViewer.setContentProvider((IContentProvider)new EventTreeContentProvider());
        this.eventViewer.setLabelProvider((IBaseLabelProvider)new EventTreeLabelProvider());
        this.eventViewer.setComparator((ViewerComparator)new EventTreeComparator());
        WidgetHelper.restoreTreeViewerSettings((SortableTreeViewer)this.eventViewer, (String)"AlarmDetails.Events");
        this.eventViewer.getControl().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void createDataSection(Composite parent) {
        this.dataSection = new Section(parent, this.i18n.tr("DCI Data"), true);
        DashboardLayoutData dd = new DashboardLayoutData();
        dd.fill = true;
        this.dataSection.setLayoutData((Object)dd);
        this.dataSection.addExpansionListener(e -> {
            dd.fill = e.getState() && this.dataSectionPopulated;
        });
        this.dataArea = new Composite(this.dataSection.getClient(), 0);
        this.dataArea.setLayout((Layout)new GridLayout());
        this.dataArea.setBackground(ThemeEngine.getBackgroundColor((String)"Chart.Base"));
    }

    public void refresh() {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void createDataAreaElements(Alarm alarm, DciValue dci) {
        this.nodeId = alarm.getSourceObjectId();
        this.dciId = alarm.getDciId();
        this.alarmDCI = new Label(this.dataArea, 0);
        GridData gd = new GridData();
        gd.horizontalAlignment = 0x1000000;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 0x1000000;
        this.alarmDCI.setLayoutData((Object)gd);
        FontData fd = this.alarmDCI.getFont().getFontData()[0];
        fd.setStyle(1);
        Font font = new Font((Device)this.alarmDCI.getDisplay(), fd);
        this.alarmDCI.setFont(font);
        this.alarmDCI.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        Threshold t = dci.getActiveThreshold();
        this.alarmDCI.setText(dci.getDescription() + (String)(t != null ? " (" + t.getTextualRepresentation() + ")" : " (OK)"));
        if (dci.getDataType() != DataType.STRING) {
            ChartConfiguration chartConfiguration = new ChartConfiguration();
            chartConfiguration.setZoomEnabled(true);
            chartConfiguration.setTitleVisible(false);
            chartConfiguration.setTitle(dci.getDescription());
            chartConfiguration.setLegendVisible(false);
            chartConfiguration.setLegendPosition(8);
            chartConfiguration.setExtendedLegend(true);
            chartConfiguration.setGridVisible(true);
            chartConfiguration.setTranslucent(true);
            this.chart = new Chart(this.dataArea, 0, ChartType.LINE, chartConfiguration);
            ChartDciConfig item = new ChartDciConfig(dci);
            item.lineChartType = 1;
            item.setColor(ColorConverter.rgbToInt((RGB)new RGB(127, 154, 72)));
            this.chart.addParameter(item);
            this.chart.rebuild();
            this.dataViewControl = this.chart;
        } else {
            ((GridLayout)this.dataArea.getLayout()).marginWidth = 0;
            ((GridLayout)this.dataArea.getLayout()).marginTop = ((GridLayout)this.dataArea.getLayout()).marginHeight;
            ((GridLayout)this.dataArea.getLayout()).marginHeight = 0;
            ((GridLayout)this.dataArea.getLayout()).verticalSpacing = 0;
            Label separator = new Label(this.dataArea, 258);
            gd = new GridData(4, 0x1000000, true, false);
            gd.verticalIndent = 5;
            separator.setLayoutData((Object)gd);
            this.dataViewer = new TableViewer(this.dataArea, 65536);
            this.dataViewer.getTable().setHeaderVisible(true);
            TableColumn tc = new TableColumn(this.dataViewer.getTable(), 16384);
            tc.setText("Timestamp");
            tc = new TableColumn(this.dataViewer.getTable(), 16384);
            tc.setText("Value");
            this.dataViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.dataViewer.setLabelProvider((IBaseLabelProvider)new HistoricalDataLabelProvider());
            this.dataViewControl = this.dataViewer.getControl();
        }
        this.dataViewControl.setLayoutData((Object)new GridData(4, 4, true, true));
        this.refreshController = new ViewRefreshController((View)this, 30, (Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void updateLayout() {
        this.content.layout(true, true);
        this.editorsArea.layout(true, true);
        this.editorsScroller.setMinSize(this.editorsArea.computeSize(this.editorsScroller.getClientArea().width, -1));
    }

    private AlarmCommentsEditor createEditor(AlarmComment note, boolean enableEditing) {
        10 editAction = new /* Unavailable Anonymous Inner Class!! */;
        11 deleteAction = new /* Unavailable Anonymous Inner Class!! */;
        AlarmCommentsEditor e = new AlarmCommentsEditor(this.editorsArea, this.imageCache, note, (HyperlinkAdapter)editAction, (HyperlinkAdapter)deleteAction, enableEditing);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        e.setLayoutData((Object)gd);
        e.moveBelow((Control)this.linkAddComment);
        return e;
    }

    private void addComment() {
        this.editComment(0L, "");
    }

    private void editComment(long noteId, String noteText) {
        EditCommentDialog dlg = new EditCommentDialog(this.getWindow().getShell(), noteId, noteText);
        if (dlg.open() != 0) {
            return;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void deleteComment(long noteId) {
        if (!MessageDialogHelper.openConfirm((Shell)this.getWindow().getShell(), (String)this.i18n.tr("Confirmation"), (String)this.i18n.tr("Are you sure you want to delete this alarm comment?"))) {
            return;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void updateAlarmDetails(Alarm alarm) {
        this.alarmSeverity.setImage(StatusDisplayInfo.getStatusImage((Severity)alarm.getCurrentSeverity()));
        this.alarmSeverity.setText(StatusDisplayInfo.getStatusText((Severity)alarm.getCurrentSeverity()));
        int state = alarm.getState();
        if (state == 1 && alarm.isSticky()) {
            state = 4;
        }
        this.alarmState.setImage(this.stateImages[state]);
        this.alarmState.setText(stateText[alarm.getState()]);
        AbstractObject object = this.session.findObjectById(alarm.getSourceObjectId());
        this.alarmSource.setImage(object != null ? this.objectLabelProvider.getImage((Object)object) : SharedIcons.IMG_UNKNOWN_OBJECT);
        this.alarmSource.setText((String)(object != null ? object.getObjectName() : "[" + Long.toString(alarm.getSourceObjectId()) + "]"));
        this.alarmKey.setText(alarm.getKey());
        this.alarmText.setText(alarm.getMessage());
        this.alarmRule.setText(String.format("Created by rule \"%s\" (%s)", alarm.getRuleDescription(), alarm.getRuleId().toString()));
    }

    public void dispose() {
        if (this.refreshController != null) {
            this.refreshController.dispose();
        }
        for (int i = 0; i < this.stateImages.length; ++i) {
            this.stateImages[i].dispose();
        }
        this.imageCache.dispose();
        this.objectLabelProvider.dispose();
        super.dispose();
    }

    private void refreshData() {
        if (this.updateInProgress) {
            return;
        }
        this.updateInProgress = true;
        14 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    public String getFullName() {
        return this.getName();
    }

    public boolean isValidForContext(Object context) {
        if (this.getObjectId() == 0L && this.getContextId() == 0L) {
            return true;
        }
        return context != null && context instanceof AbstractObject && (((AbstractObject)context).getObjectId() == this.getObjectId() || ((AbstractObject)context).getObjectId() == this.getContextId());
    }

    public void saveState(Memento memento) {
        super.saveState(memento);
        memento.set("alarmId", this.alarmId);
    }

    public void restoreState(Memento memento) throws ViewNotRestoredException {
        super.restoreState(memento);
        this.alarmId = memento.getAsLong("alarmId", 0L);
        this.setName(String.format(LocalizationHelper.getI18n(AlarmDetails.class).tr("Alarm Details [%d]"), this.alarmId));
        if (this.alarmId == 0L) {
            throw new ViewNotRestoredException(this.i18n.tr("Invalid alarm id"));
        }
    }

    static /* synthetic */ NXCSession access$000(AlarmDetails x0) {
        return x0.session;
    }

    static /* synthetic */ NXCSession access$100(AlarmDetails x0) {
        return x0.session;
    }

    static /* synthetic */ NXCSession access$200(AlarmDetails x0) {
        return x0.session;
    }

    static /* synthetic */ NXCSession access$300(AlarmDetails x0) {
        return x0.session;
    }

    static /* synthetic */ NXCSession access$400(AlarmDetails x0) {
        return x0.session;
    }

    static /* synthetic */ NXCSession access$500(AlarmDetails x0) {
        return x0.session;
    }

    static /* synthetic */ NXCSession access$600(AlarmDetails x0) {
        return x0.session;
    }

    static /* synthetic */ NXCSession access$700(AlarmDetails x0) {
        return x0.session;
    }

    static /* synthetic */ NXCSession access$800(AlarmDetails x0) {
        return x0.session;
    }
}

