/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.alarms.widgets.helpers;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.netxms.client.NXCSession;
import org.netxms.client.events.Alarm;
import org.netxms.client.events.AlarmHandle;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.search.SearchQuery;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.localization.LocalizationHelper;

public class AlarmListFilter
extends ViewerFilter
implements AbstractViewerFilter {
    private static final String[] stateText = new String[]{LocalizationHelper.getI18n(AlarmListFilter.class).tr("Outstanding"), LocalizationHelper.getI18n(AlarmListFilter.class).tr("Acknowledged"), LocalizationHelper.getI18n(AlarmListFilter.class).tr("Resolved"), LocalizationHelper.getI18n(AlarmListFilter.class).tr("Terminated")};
    private Set<Long> rootObjects = new HashSet();
    private int stateFilter = 255;
    private int severityFilter = 255;
    private NXCSession session = Registry.getSession();
    private String filterString = null;
    private SearchQuery query = null;

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.query == null) {
            return true;
        }
        Alarm alarm = ((AlarmHandle)element).alarm;
        return this.query.match((Object)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean filter(Alarm alarm) {
        if ((alarm.getStateBit() & this.stateFilter) == 0) {
            return false;
        }
        if ((1 << alarm.getCurrentSeverity().getValue() & this.severityFilter) == 0) {
            return false;
        }
        Set set = this.rootObjects;
        synchronized (set) {
            if (this.rootObjects.isEmpty() || this.rootObjects.contains(alarm.getSourceObjectId())) {
                return true;
            }
            AbstractObject object = this.session.findObjectById(alarm.getSourceObjectId());
            if (object != null) {
                long[] rootObjectsArray = new long[this.rootObjects.size()];
                int i = 0;
                Iterator iterator = this.rootObjects.iterator();
                while (iterator.hasNext()) {
                    long objectId = (Long)iterator.next();
                    rootObjectsArray[i++] = objectId;
                }
                return object.isChildOf(rootObjectsArray);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setRootObject(long rootObject) {
        Set set = this.rootObjects;
        synchronized (set) {
            this.rootObjects.clear();
            if (rootObject != 0L) {
                this.rootObjects.add(rootObject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRootObjects(List<Long> rootObjects) {
        Set set = this.rootObjects;
        synchronized (set) {
            this.rootObjects.clear();
            this.rootObjects.addAll(rootObjects);
        }
    }

    public void setStateFilter(int stateFilter) {
        this.stateFilter = stateFilter;
    }

    public void setSeverityFilter(int severityFilter) {
        this.severityFilter = severityFilter;
    }

    public String getFilterString() {
        return this.filterString;
    }

    public void setFilterString(String filterString) {
        if (filterString == null) {
            this.filterString = null;
            this.query = null;
            return;
        }
        String s = filterString.toLowerCase().trim();
        if (!s.equals(this.filterString)) {
            this.filterString = s;
            this.query = !s.isEmpty() ? new SearchQuery(s) : null;
        }
    }
}

