/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.charts.widgets;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.netxms.client.constants.Severity;
import org.netxms.client.datacollection.ChartConfiguration;
import org.netxms.client.datacollection.ChartDciConfig;
import org.netxms.client.datacollection.DataFormatter;
import org.netxms.nxmc.modules.charts.api.DataSeries;
import org.netxms.nxmc.modules.charts.api.GaugeColorMode;
import org.netxms.nxmc.modules.charts.widgets.Chart;
import org.netxms.nxmc.modules.charts.widgets.GenericGauge;
import org.netxms.nxmc.resources.StatusDisplayInfo;
import org.netxms.nxmc.resources.ThemeEngine;
import org.netxms.nxmc.tools.WidgetHelper;

/*
 * Exception performing whole class analysis ignored.
 */
public class BarGauge
extends GenericGauge {
    private static final int MAX_BAR_THICKNESS = 40;
    private static final int SCALE_TEXT_HEIGHT = 20;
    private static final int SCALE_TEXT_WIDTH = 80;
    private Font[] scaleFonts = null;

    public BarGauge(Chart parent) {
        super(parent);
    }

    protected void createFonts() {
        String fontName = this.chart.getConfiguration().getFontName();
        this.scaleFonts = new Font[16];
        for (int i = 0; i < this.scaleFonts.length; ++i) {
            this.scaleFonts[i] = new Font((Device)this.getDisplay(), fontName, i + 6, 0);
        }
    }

    protected void disposeFonts() {
        if (this.scaleFonts != null) {
            for (int i = 0; i < this.scaleFonts.length; ++i) {
                this.scaleFonts[i].dispose();
            }
        }
    }

    protected void renderElement(GC gc, ChartConfiguration config, Object renderData, ChartDciConfig dci, DataSeries data, int x, int y, int w, int h, int index) {
        double pointValue;
        Rectangle rect = new Rectangle(x + 5, y + 5, w - 10, h - 10);
        gc.setAntialias(1);
        if (config.areLabelsVisible()) {
            gc.setForeground(ThemeEngine.getForegroundColor((String)"Chart.Base"));
            gc.setFont(null);
            Point legendExt = gc.textExtent(dci.getLabel());
            switch (config.getLegendPosition()) {
                case 4: {
                    gc.drawText(dci.getLabel(), rect.x + (rect.width - legendExt.x) / 2, rect.y + 4, true);
                    rect.y += legendExt.y + 8;
                    rect.height -= legendExt.y + 8;
                    break;
                }
                case 8: {
                    rect.height -= legendExt.y + 8;
                    gc.drawText(dci.getLabel(), rect.x + (rect.width - legendExt.x) / 2, rect.y + rect.height + 4, true);
                    break;
                }
                case 1: {
                    gc.drawText(dci.getLabel(), rect.x + 4, rect.y + (rect.height - legendExt.y) / 2, true);
                    rect.x += legendExt.x + 8;
                    rect.width -= legendExt.x + 8;
                    break;
                }
                case 2: {
                    rect.width -= legendExt.x + 8;
                    gc.drawText(dci.getLabel(), rect.x + rect.width + 4, rect.y + (rect.height - legendExt.y) / 2, true);
                }
            }
        }
        if (config.isTransposed()) {
            if (rect.height > 40) {
                int d = rect.height - 40;
                rect.height -= d;
                rect.y += d / 2;
            }
            rect.y -= 10;
        } else if (rect.width > 40) {
            int d = rect.width - 40;
            rect.width -= d;
            rect.x += d / 2;
        }
        gc.setBackground(ThemeEngine.getBackgroundColor((String)"Chart.PlotArea"));
        gc.fillRectangle(rect);
        double maxValue = config.getMaxYScaleValue();
        double minValue = config.getMinYScaleValue();
        double d = pointValue = config.isTransposed() ? (maxValue - minValue) / (double)rect.width : (maxValue - minValue) / (double)rect.height;
        if (data.getCurrentValue() > minValue) {
            GaugeColorMode colorMode = GaugeColorMode.getByValue((int)config.getGaugeColorMode());
            if (colorMode == GaugeColorMode.ZONE) {
                this.drawZone(gc, rect, minValue, config.getLeftRedZone(), minValue, pointValue, RED_ZONE_COLOR, config.isTransposed());
                this.drawZone(gc, rect, config.getLeftRedZone(), config.getLeftYellowZone(), minValue, pointValue, YELLOW_ZONE_COLOR, config.isTransposed());
                this.drawZone(gc, rect, config.getLeftYellowZone(), config.getRightYellowZone(), minValue, pointValue, GREEN_ZONE_COLOR, config.isTransposed());
                this.drawZone(gc, rect, config.getRightYellowZone(), config.getRightRedZone(), minValue, pointValue, YELLOW_ZONE_COLOR, config.isTransposed());
                this.drawZone(gc, rect, config.getRightRedZone(), maxValue, minValue, pointValue, RED_ZONE_COLOR, config.isTransposed());
                double v = data.getCurrentValue();
                if (v < maxValue) {
                    gc.setBackground(ThemeEngine.getBackgroundColor((String)"Chart.Gauge"));
                    if (config.isTransposed()) {
                        int points = (int)((v - minValue) / pointValue);
                        gc.fillRectangle(rect.x + points, rect.y, rect.width - points + 1, rect.height);
                    } else {
                        int points = (int)((maxValue - v) / pointValue);
                        gc.fillRectangle(rect.x, rect.y, rect.width, points);
                    }
                }
            } else {
                gc.setBackground(ThemeEngine.getBackgroundColor((String)"Chart.Gauge"));
                gc.fillRectangle(rect);
                if (colorMode == GaugeColorMode.THRESHOLD) {
                    gc.setBackground(StatusDisplayInfo.getStatusColor((Severity)data.getActiveThresholdSeverity()));
                } else if (colorMode == GaugeColorMode.DATA_SOURCE) {
                    gc.setBackground(this.chart.getColorCache().create(this.getDataSourceColor(dci, index)));
                } else {
                    gc.setBackground(this.chart.getColorCache().create(this.chart.getPaletteEntry(0).getRGBObject()));
                }
                int points = (int)((data.getCurrentValue() - minValue) / pointValue);
                if (config.isTransposed()) {
                    if (points > rect.width) {
                        points = rect.width;
                    }
                    gc.fillRectangle(rect.x, rect.y, points, rect.height);
                } else {
                    if (points > rect.height) {
                        points = rect.height;
                    }
                    gc.fillRectangle(rect.x, rect.y + rect.height - points, rect.width, points);
                }
            }
        }
        this.drawScale(gc, rect, minValue, maxValue, pointValue, config.isTransposed(), config.isGridVisible());
    }

    private void drawZone(GC gc, Rectangle rect, double startValue, double endValue, double minValue, double pointValue, RGB color, boolean isTransposed) {
        float start = (float)((startValue - minValue) / pointValue);
        float points = (float)((endValue - startValue) / pointValue);
        if (isTransposed) {
            gc.setBackground(this.chart.getColorCache().create(color));
            gc.fillRectangle(rect.x + Math.round(start), rect.y, Math.round(points), rect.height);
        } else {
            gc.setBackground(this.chart.getColorCache().create(color));
            float y = (float)(rect.y + rect.height) - start - points;
            if (y + points >= (float)(rect.y + rect.height)) {
                points -= 1.0f;
            }
            gc.fillRectangle(rect.x, Math.round(y), rect.width, Math.round(points));
        }
    }

    private void drawScale(GC gc, Rectangle rect, double minValue, double maxValue, double pointValue, boolean isTransposed, boolean gridVisible) {
        gc.setForeground(ThemeEngine.getForegroundColor((String)"Chart.DialScale"));
        Font markFont = WidgetHelper.getBestFittingFont((GC)gc, (Font[])this.scaleFonts, (String)"900MM", (int)80, (int)20);
        gc.setFont(markFont);
        double step = BarGauge.getStepMagnitude((double)Math.max(Math.abs(minValue), Math.abs(maxValue)));
        double value = minValue;
        float pointsStep = (float)(step / pointValue);
        if (pointsStep < 40.0f) {
            int factor = Math.round(40.0f / pointsStep);
            pointsStep *= (float)factor;
            step *= (double)factor;
        }
        if (isTransposed) {
            float x = 0.0f;
            while (x < (float)rect.width) {
                String text = DataFormatter.roundDecimalValue((double)value, (double)step, (int)5);
                gc.drawText(text, rect.x + (int)x, rect.y + rect.height + 4, 1);
                x += pointsStep;
                value += step;
            }
        } else {
            int textHeight = gc.textExtent((String)"999MM").y;
            float y = rect.height;
            while (y > 0.0f) {
                String text = DataFormatter.roundDecimalValue((double)value, (double)step, (int)5);
                gc.drawText(text, rect.x + rect.width + 4, rect.y + (int)y - textHeight * 3 / 4, 1);
                y -= pointsStep;
                value += step;
            }
        }
    }

    private static double getStepMagnitude(double maxValue) {
        double d;
        for (d = 1.0E-5; !(!(d < 1.0E19) || maxValue > d && maxValue <= d * 10.0); d *= 10.0) {
        }
        return d;
    }
}

