/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.propertypages;

import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.DciSummaryTableConfig;
import org.netxms.nxmc.modules.dashboards.dialogs.SortingColumnSelectionDialog;
import org.netxms.nxmc.modules.dashboards.propertypages.DashboardElementPropertyPage;
import org.netxms.nxmc.modules.dashboards.propertypages.helpers.SortColumnTableLabelProvider;
import org.netxms.nxmc.modules.dashboards.widgets.TitleConfigurator;
import org.netxms.nxmc.modules.datacollection.widgets.SummaryTableSelector;
import org.netxms.nxmc.modules.objects.widgets.ObjectSelector;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class DciSummaryTable
extends DashboardElementPropertyPage {
    private final I18n i18n = LocalizationHelper.getI18n(DciSummaryTable.class);
    public static final int NAME = 0;
    public static final int ORDER = 1;
    private DciSummaryTableConfig config;
    private List<String> currSortingList;
    private TitleConfigurator title;
    private ObjectSelector objectSelector;
    private SummaryTableSelector tableSelector;
    private Spinner refreshInterval;
    private Spinner numRowsShow;
    private SortableTableViewer sortTables;
    private Button buttonAdd;
    private Button buttonEdit;
    private Button buttonRemove;
    private Button buttonUp;
    private Button buttonDown;

    public DciSummaryTable(DashboardElementConfig elementConfig) {
        super(LocalizationHelper.getI18n(DciSummaryTable.class).tr("DCI Summary Table"), elementConfig);
    }

    public String getId() {
        return "dci-summary-table";
    }

    public boolean isVisible() {
        return this.elementConfig instanceof DciSummaryTableConfig;
    }

    public int getPriority() {
        return 0;
    }

    protected Control createContents(Composite parent) {
        this.config = (DciSummaryTableConfig)this.elementConfig;
        Composite dialogArea = new Composite(parent, 0);
        this.currSortingList = this.config.getSortingColumnList();
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        dialogArea.setLayout((Layout)layout);
        this.title = new TitleConfigurator(dialogArea, (DashboardElementConfig)this.config);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.title.setLayoutData((Object)gd);
        this.objectSelector = new ObjectSelector(dialogArea, 0, true, true);
        this.objectSelector.setLabel(this.i18n.tr("Base object"));
        this.objectSelector.setObjectClass(AbstractObject.class);
        this.objectSelector.setObjectId(this.config.getBaseObjectId());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.objectSelector.setLayoutData((Object)gd);
        this.tableSelector = new SummaryTableSelector(dialogArea, 0);
        this.tableSelector.setLabel(this.i18n.tr("Summary table"));
        this.tableSelector.setTableId(this.config.getTableId());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.tableSelector.setLayoutData((Object)gd);
        gd = new GridData();
        gd.verticalAlignment = 128;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.refreshInterval = WidgetHelper.createLabeledSpinner((Composite)dialogArea, (int)2048, (String)this.i18n.tr("Refresh interval"), (int)0, (int)10000, (Object)gd);
        this.refreshInterval.setSelection(this.config.getRefreshInterval());
        gd = new GridData();
        gd.verticalAlignment = 128;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.numRowsShow = WidgetHelper.createLabeledSpinner((Composite)dialogArea, (int)2048, (String)this.i18n.tr("Display limit (0 for unlimited)"), (int)0, (int)10000, (Object)gd);
        this.numRowsShow.setSelection(this.config.getNumRowShown());
        Label label = new Label(dialogArea, 0);
        label.setText(this.i18n.tr("Ordering"));
        String[] columnNames = new String[]{this.i18n.tr("Column"), this.i18n.tr("Direction")};
        int[] columnWidths = new int[]{300, 100};
        this.sortTables = new SortableTableViewer(dialogArea, columnNames, columnWidths, 0, 0, 67586);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = 2;
        gd.heightHint = 150;
        this.sortTables.getTable().setLayoutData((Object)gd);
        this.sortTables.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.sortTables.setLabelProvider((IBaseLabelProvider)new SortColumnTableLabelProvider());
        this.sortTables.setInput((Object)this.currSortingList);
        this.sortTables.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.sortTables.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        Composite buttons = new Composite(dialogArea, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 45;
        buttons.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        buttons.setLayoutData((Object)gd);
        Composite leftButtons = new Composite(buttons, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginLeft = 0;
        buttonLayout.marginRight = 0;
        buttonLayout.marginTop = 0;
        buttonLayout.marginBottom = 0;
        leftButtons.setLayout((Layout)buttonLayout);
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        gd.grabExcessHorizontalSpace = true;
        leftButtons.setLayoutData((Object)gd);
        this.buttonUp = new Button(leftButtons, 8);
        this.buttonUp.setText(this.i18n.tr("&Up"));
        this.buttonUp.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        RowData rd = new RowData();
        rd.width = 90;
        this.buttonUp.setLayoutData((Object)rd);
        this.buttonUp.setEnabled(false);
        this.buttonDown = new Button(leftButtons, 8);
        this.buttonDown.setText(this.i18n.tr("Dow&n"));
        this.buttonDown.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        rd = new RowData();
        rd.width = 90;
        this.buttonDown.setLayoutData((Object)rd);
        this.buttonDown.setEnabled(false);
        Composite rightButtons = new Composite(buttons, 0);
        buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginLeft = 0;
        buttonLayout.marginRight = 0;
        buttonLayout.marginTop = 0;
        buttonLayout.marginBottom = 0;
        rightButtons.setLayout((Layout)buttonLayout);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        gd.grabExcessHorizontalSpace = true;
        rightButtons.setLayoutData((Object)gd);
        this.buttonAdd = new Button(rightButtons, 8);
        this.buttonAdd.setText(this.i18n.tr("&Add..."));
        this.buttonAdd.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        rd = new RowData();
        rd.width = 90;
        this.buttonAdd.setLayoutData((Object)rd);
        this.buttonEdit = new Button(rightButtons, 8);
        this.buttonEdit.setText("&Edit...");
        this.buttonEdit.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        rd = new RowData();
        rd.width = 90;
        this.buttonEdit.setLayoutData((Object)rd);
        this.buttonEdit.setEnabled(false);
        this.buttonRemove = new Button(rightButtons, 8);
        this.buttonRemove.setText(this.i18n.tr("&Delete"));
        this.buttonRemove.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        rd = new RowData();
        rd.width = 90;
        this.buttonRemove.setLayoutData((Object)rd);
        this.buttonRemove.setEnabled(false);
        return dialogArea;
    }

    private void moveUp() {
        IStructuredSelection selection = (IStructuredSelection)this.sortTables.getSelection();
        if (selection.size() != 1) {
            return;
        }
        String element = (String)selection.getFirstElement();
        int index = this.currSortingList.indexOf(element);
        if (index <= 0) {
            return;
        }
        String a = (String)this.currSortingList.get(index - 1);
        this.currSortingList.set(index - 1, (String)this.currSortingList.get(index));
        this.currSortingList.set(index, a);
        this.sortTables.setInput((Object)this.currSortingList.toArray());
        this.sortTables.setSelection((ISelection)selection);
    }

    private void moveDown() {
        IStructuredSelection selection = (IStructuredSelection)this.sortTables.getSelection();
        if (selection.size() != 1) {
            return;
        }
        String element = (String)selection.getFirstElement();
        int index = this.currSortingList.indexOf(element);
        if (index >= this.currSortingList.size() - 1 && index < 0) {
            return;
        }
        String a = (String)this.currSortingList.get(index + 1);
        this.currSortingList.set(index + 1, (String)this.currSortingList.get(index));
        this.currSortingList.set(index, a);
        this.sortTables.setInput((Object)this.currSortingList.toArray());
        this.sortTables.setSelection((ISelection)selection);
    }

    private void add() {
        String s;
        SortingColumnSelectionDialog dlg = new SortingColumnSelectionDialog(this.getShell(), null, false, this.tableSelector.getTableId());
        if (dlg.open() == 0 && !this.currSortingList.contains(s = dlg.getColumnName())) {
            this.currSortingList.add(s);
            this.sortTables.setInput((Object)this.currSortingList.toArray());
        }
    }

    private void edit() {
        IStructuredSelection selection = (IStructuredSelection)this.sortTables.getSelection();
        if (selection.size() != 1) {
            return;
        }
        String element = (String)selection.getFirstElement();
        SortingColumnSelectionDialog dlg = new SortingColumnSelectionDialog(this.getShell(), element.substring(1), element.charAt(0) == '>', this.tableSelector.getTableId());
        if (dlg.open() == 0) {
            String s = dlg.getColumnName();
            int index = this.currSortingList.indexOf(element);
            if (index < this.currSortingList.size() && index >= 0) {
                this.currSortingList.set(index, s);
                this.sortTables.setInput((Object)this.currSortingList.toArray());
            }
        }
    }

    private void remove() {
        IStructuredSelection selection = (IStructuredSelection)this.sortTables.getSelection();
        if (selection.size() != 1) {
            return;
        }
        String element = (String)selection.getFirstElement();
        this.currSortingList.remove(element);
        this.sortTables.setInput((Object)this.currSortingList.toArray());
    }

    protected boolean applyChanges(boolean isApply) {
        this.title.updateConfiguration((DashboardElementConfig)this.config);
        this.config.setBaseObjectId(this.objectSelector.getObjectId());
        this.config.setTableId(this.tableSelector.getTableId());
        this.config.setRefreshInterval(this.refreshInterval.getSelection());
        this.config.setNumRowShown(this.numRowsShow.getSelection());
        this.config.setSortingColumnList(this.currSortingList);
        return true;
    }
}

