/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.propertypages;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.objects.Node;
import org.netxms.nxmc.base.widgets.LabeledSpinner;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.FileMonitorConfig;
import org.netxms.nxmc.modules.dashboards.propertypages.DashboardElementPropertyPage;
import org.netxms.nxmc.modules.dashboards.widgets.TitleConfigurator;
import org.netxms.nxmc.modules.objects.widgets.ObjectSelector;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class FileMonitor
extends DashboardElementPropertyPage {
    private final I18n i18n = LocalizationHelper.getI18n(FileMonitor.class);
    private FileMonitorConfig config;
    private ObjectSelector objectSelector;
    private LabeledText fileName;
    private LabeledText filter;
    private LabeledSpinner historyLimit;
    private Combo syntaxHighlighter;
    private TitleConfigurator title;

    public FileMonitor(DashboardElementConfig elementConfig) {
        super(LocalizationHelper.getI18n(FileMonitor.class).tr("File Monitor"), elementConfig);
    }

    public String getId() {
        return "file-monitor";
    }

    public boolean isVisible() {
        return this.elementConfig instanceof FileMonitorConfig;
    }

    public int getPriority() {
        return 0;
    }

    protected Control createContents(Composite parent) {
        this.config = (FileMonitorConfig)this.elementConfig;
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.title = new TitleConfigurator(dialogArea, (DashboardElementConfig)this.config);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.title.setLayoutData((Object)gd);
        this.objectSelector = new ObjectSelector(dialogArea, 0, true, true);
        this.objectSelector.setLabel(this.i18n.tr("Node"));
        this.objectSelector.setObjectClass(Node.class);
        this.objectSelector.setObjectId(this.config.getObjectId());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.objectSelector.setLayoutData((Object)gd);
        this.fileName = new LabeledText(dialogArea, 0);
        this.fileName.setLabel(this.i18n.tr("File name"));
        this.fileName.setText(this.config.getFileName());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.fileName.setLayoutData((Object)gd);
        this.filter = new LabeledText(dialogArea, 0);
        this.filter.setLabel(this.i18n.tr("Line filter (regular expression)"));
        this.filter.setText(this.config.getFilter());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.filter.setLayoutData((Object)gd);
        this.historyLimit = new LabeledSpinner(dialogArea, 0);
        this.historyLimit.setLabel(this.i18n.tr("History limit"));
        this.historyLimit.setRange(0, 99999999);
        this.historyLimit.setSelection(this.config.getHistoryLimit());
        this.syntaxHighlighter = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)2056, (String)this.i18n.tr("Highlighter"), (Object)"WidgetHelper::default_layout_data");
        this.syntaxHighlighter.add(this.i18n.tr("None"));
        int index = this.syntaxHighlighter.indexOf(this.config.getSyntaxHighlighter());
        this.syntaxHighlighter.select(index >= 0 ? index : 0);
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        this.title.updateConfiguration((DashboardElementConfig)this.config);
        this.config.setObjectId(this.objectSelector.getObjectId());
        this.config.setFileName(this.fileName.getText().trim());
        this.config.setFilter(this.filter.getText());
        this.config.setHistoryLimit(this.historyLimit.getSelection());
        this.config.setSyntaxHighlighter(this.syntaxHighlighter.getText());
        return true;
    }
}

