/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.propertypages;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.ObjectStatusChartConfig;
import org.netxms.nxmc.modules.dashboards.propertypages.DashboardElementPropertyPage;
import org.netxms.nxmc.modules.dashboards.widgets.TitleConfigurator;
import org.netxms.nxmc.modules.objects.widgets.ObjectSelector;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class ObjectStatusChart
extends DashboardElementPropertyPage {
    private final I18n i18n = LocalizationHelper.getI18n(ObjectStatusChart.class);
    private ObjectStatusChartConfig config;
    private ObjectSelector objectSelector;
    private TitleConfigurator title;
    private Spinner refreshRate;
    private Button checkShowLegend;
    private Button checkTransposed;
    private Button checkTranslucent;

    public ObjectStatusChart(DashboardElementConfig elementConfig) {
        super(LocalizationHelper.getI18n(ObjectStatusChart.class).tr("Object Status Chart"), elementConfig);
    }

    public String getId() {
        return "object-status-chart";
    }

    public boolean isVisible() {
        return this.elementConfig instanceof ObjectStatusChartConfig;
    }

    public int getPriority() {
        return 0;
    }

    protected Control createContents(Composite parent) {
        this.config = (ObjectStatusChartConfig)this.elementConfig;
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.objectSelector = new ObjectSelector(dialogArea, 0, false, true);
        this.objectSelector.setLabel(this.i18n.tr("Root object"));
        this.objectSelector.setObjectClass(AbstractObject.class);
        this.objectSelector.setObjectId(this.config.getRootObject());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.objectSelector.setLayoutData((Object)gd);
        this.title = new TitleConfigurator(dialogArea, (DashboardElementConfig)this.config);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.title.setLayoutData((Object)gd);
        Group optionsGroup = new Group(dialogArea, 0);
        optionsGroup.setText(this.i18n.tr("Options"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        optionsGroup.setLayoutData((Object)gd);
        GridLayout optionsLayout = new GridLayout();
        optionsGroup.setLayout((Layout)optionsLayout);
        this.checkShowLegend = new Button((Composite)optionsGroup, 32);
        this.checkShowLegend.setText(this.i18n.tr("Show &legend"));
        this.checkShowLegend.setSelection(this.config.isShowLegend());
        this.checkTransposed = new Button((Composite)optionsGroup, 32);
        this.checkTransposed.setText(this.i18n.tr("Trans&posed"));
        this.checkTransposed.setSelection(this.config.isTransposed());
        this.checkTranslucent = new Button((Composite)optionsGroup, 32);
        this.checkTranslucent.setText(this.i18n.tr("&Translucent"));
        this.checkTranslucent.setSelection(this.config.isTranslucent());
        gd = new GridData();
        gd.verticalAlignment = 128;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.refreshRate = WidgetHelper.createLabeledSpinner((Composite)dialogArea, (int)2048, (String)this.i18n.tr("Refresh interval (seconds)"), (int)1, (int)10000, (Object)gd);
        this.refreshRate.setSelection(this.config.getRefreshRate());
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        this.title.updateConfiguration((DashboardElementConfig)this.config);
        this.config.setRootObject(this.objectSelector.getObjectId());
        this.config.setShowLegend(this.checkShowLegend.getSelection());
        this.config.setTransposed(this.checkTransposed.getSelection());
        this.config.setTranslucent(this.checkTranslucent.getSelection());
        this.config.setRefreshRate(this.refreshRate.getSelection());
        return true;
    }
}

