/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.propertypages;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.TableComparisonChartConfig;
import org.netxms.nxmc.modules.dashboards.propertypages.DashboardElementPropertyPage;
import org.netxms.nxmc.modules.datacollection.widgets.DciSelector;
import org.xnap.commons.i18n.I18n;

public class TableDataSource
extends DashboardElementPropertyPage {
    private final I18n i18n = LocalizationHelper.getI18n(TableDataSource.class);
    private TableComparisonChartConfig config;
    private DciSelector dci;
    private LabeledText instanceColumn;
    private LabeledText dataColumn;
    private Button checkIgnoreZeroValues;
    private Button checkSortOnDataColumn;
    private Button checkSortDescending;

    public TableDataSource(DashboardElementConfig elementConfig) {
        super(LocalizationHelper.getI18n(TableDataSource.class).tr("Data Source"), elementConfig);
    }

    public String getId() {
        return "table-data-source";
    }

    public boolean isVisible() {
        return this.elementConfig instanceof TableComparisonChartConfig;
    }

    public int getPriority() {
        return 20;
    }

    protected Control createContents(Composite parent) {
        this.config = (TableComparisonChartConfig)this.elementConfig;
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        dialogArea.setLayout((Layout)layout);
        this.dci = new DciSelector(dialogArea, 0);
        this.dci.setLabel(this.i18n.tr("Table DCI"));
        this.dci.setDciId(this.config.getNodeId(), this.config.getDciId());
        this.dci.setDcObjectType(2);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.dci.setLayoutData((Object)gd);
        this.instanceColumn = new LabeledText(dialogArea, 0);
        this.instanceColumn.setLabel(this.i18n.tr("Instance column"));
        this.instanceColumn.setText(this.config.getInstanceColumn());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.instanceColumn.setLayoutData((Object)gd);
        this.dataColumn = new LabeledText(dialogArea, 0);
        this.dataColumn.setLabel(this.i18n.tr("Data column"));
        this.dataColumn.setText(this.config.getDataColumn());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.dataColumn.setLayoutData((Object)gd);
        this.checkIgnoreZeroValues = new Button(dialogArea, 32);
        this.checkIgnoreZeroValues.setText(this.i18n.tr("&Ignore zero values when building chart"));
        this.checkIgnoreZeroValues.setSelection(this.config.isIgnoreZeroValues());
        this.checkSortOnDataColumn = new Button(dialogArea, 32);
        this.checkSortOnDataColumn.setText(this.i18n.tr("&Sort table on data column"));
        this.checkSortOnDataColumn.setSelection(this.config.isSortOnDataColumn());
        this.checkSortDescending = new Button(dialogArea, 32);
        this.checkSortDescending.setText(this.i18n.tr("Sort &descending"));
        this.checkSortDescending.setSelection(this.config.isSortDescending());
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        this.config.setNodeId(this.dci.getNodeId());
        this.config.setDciId(this.dci.getDciId());
        this.config.setInstanceColumn(this.instanceColumn.getText().trim());
        this.config.setDataColumn(this.dataColumn.getText().trim());
        this.config.setIgnoreZeroValues(this.checkIgnoreZeroValues.getSelection());
        this.config.setSortOnDataColumn(this.checkSortOnDataColumn.getSelection());
        this.config.setSortDescending(this.checkSortDescending.getSelection());
        return true;
    }
}

