/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.propertypages.helpers;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.ChartDciConfig;
import org.netxms.client.datacollection.DciInfo;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.xnap.commons.i18n.I18n;

public class DciListLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private final I18n i18n = LocalizationHelper.getI18n(DciListLabelProvider.class);
    private final DciInfo unresolvedDci = new DciInfo(this.i18n.tr("<unresolved>"), this.i18n.tr("<unresolved>"), "");
    private NXCSession session;
    private Map<Long, DciInfo> dciNameCache = new HashMap();
    private List<ChartDciConfig> elementList;

    public DciListLabelProvider(List<ChartDciConfig> elementList) {
        this.elementList = elementList;
        this.session = Registry.getSession();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        ChartDciConfig dci = (ChartDciConfig)element;
        switch (columnIndex) {
            case 0: {
                return Integer.toString(this.elementList.indexOf(dci) + 1);
            }
            case 1: {
                return dci.nodeId == 0L || dci.nodeId == 0xFFFFFFFFL ? this.i18n.tr("<context>") : (dci.nodeId == 0xFFFFFFFEL ? this.i18n.tr("<unknown>") : this.session.getObjectName(dci.nodeId));
            }
            case 2: {
                if (dci.dciId == 0L) {
                    return dci.dciDescription;
                }
                String displayName = this.safeDciLookup((long)dci.dciId).displayName;
                return displayName != null ? displayName : this.i18n.tr("<unresolved>");
            }
            case 4: {
                if (dci.dciId == 0L) {
                    return dci.dciTag;
                }
                String tag = this.safeDciLookup((long)dci.dciId).userTag;
                return tag != null ? tag : "";
            }
            case 3: {
                if (dci.dciId == 0L) {
                    return dci.dciName;
                }
                String name = this.safeDciLookup((long)dci.dciId).metric;
                return name != null ? name : this.i18n.tr("<unresolved>");
            }
            case 5: {
                return dci.name;
            }
            case 6: {
                return dci.color.equalsIgnoreCase("UNSET") ? this.i18n.tr("auto") : dci.color;
            }
        }
        return null;
    }

    private DciInfo safeDciLookup(long dciId) {
        DciInfo i = (DciInfo)this.dciNameCache.get(dciId);
        return i != null ? i : this.unresolvedDci;
    }

    public void resolveDciNames(Collection<ChartDciConfig> dciList) {
        new /* Unavailable Anonymous Inner Class!! */.runInForeground();
    }

    public void addCacheEntry(long nodeId, long dciId, String metric, String displayName, String userTag) {
        this.dciNameCache.put(dciId, new DciInfo(metric, displayName, userTag));
    }
}

