/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.widgets;

import com.google.gson.Gson;
import java.util.Date;
import org.eclipse.swt.events.DisposeListener;
import org.netxms.client.NXCSession;
import org.netxms.client.TimePeriod;
import org.netxms.client.constants.TimeFrameType;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.datacollection.ChartConfiguration;
import org.netxms.client.datacollection.ChartDciConfig;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.charts.api.ChartColor;
import org.netxms.nxmc.modules.charts.api.ChartType;
import org.netxms.nxmc.modules.charts.widgets.Chart;
import org.netxms.nxmc.modules.dashboards.config.AvailabilityChartConfig;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.views.AbstractDashboardView;
import org.netxms.nxmc.modules.dashboards.widgets.AvailabilityChartElement;
import org.netxms.nxmc.modules.dashboards.widgets.DashboardControl;
import org.netxms.nxmc.modules.dashboards.widgets.ElementWidget;
import org.netxms.nxmc.tools.DateBuilder;
import org.netxms.nxmc.tools.ViewRefreshController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

/*
 * Exception performing whole class analysis ignored.
 */
public class AvailabilityChartElement
extends ElementWidget {
    private static final Logger logger = LoggerFactory.getLogger(AvailabilityChartElement.class);
    private final I18n i18n = LocalizationHelper.getI18n(AvailabilityChartElement.class);
    private AvailabilityChartConfig elementConfig;
    private Chart chart;
    private NXCSession session = Registry.getSession();
    private ViewRefreshController refreshController;

    public AvailabilityChartElement(DashboardControl parent, DashboardElement element, AbstractDashboardView view) {
        super(parent, element, view);
        this.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        try {
            this.elementConfig = (AvailabilityChartConfig)new Gson().fromJson(element.getData(), AvailabilityChartConfig.class);
        }
        catch (Exception e) {
            logger.error("Cannot parse dashboard element configuration", (Throwable)e);
            this.elementConfig = new AvailabilityChartConfig();
        }
        this.processCommonSettings((DashboardElementConfig)this.elementConfig);
        ChartConfiguration chartConfig = new ChartConfiguration();
        chartConfig.setTitleVisible(false);
        chartConfig.setLegendPosition(this.elementConfig.getLegendPosition());
        chartConfig.setLegendVisible(this.elementConfig.isShowLegend());
        chartConfig.setTranslucent(this.elementConfig.isTranslucent());
        this.chart = new Chart(this.getContentArea(), 0, ChartType.PIE, chartConfig);
        this.chart.addParameter(new ChartDciConfig(this.i18n.tr("Uptime")));
        this.chart.addParameter(new ChartDciConfig(this.i18n.tr("Downtime")));
        this.chart.setPaletteEntry(0, new ChartColor(127, 154, 72));
        this.chart.setPaletteEntry(1, new ChartColor(158, 65, 62));
        this.chart.rebuild();
        if ((this.elementConfig.getPeriod() & 1) == 0) {
            this.refreshController = new ViewRefreshController((View)view, 60, (Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.refreshData();
    }

    private void refreshData() {
        TimePeriod timePeriod = AvailabilityChartElement.buildTimePeriod((int)this.elementConfig.getPeriod(), (int)this.elementConfig.getNumberOfDays());
        3 availabilityJob = new /* Unavailable Anonymous Inner Class!! */;
        availabilityJob.setUser(false);
        availabilityJob.start();
    }

    private static TimePeriod buildTimePeriod(int periodType, int numberOfDays) {
        switch (periodType) {
            case 8: {
                return new TimePeriod(TimeFrameType.FIXED, 0, null, new DateBuilder().add(5, 1 - numberOfDays).setMidnight().create(), new Date());
            }
            case 5: {
                return new TimePeriod(TimeFrameType.FIXED, 0, null, new DateBuilder().add(2, -1).set(5, 1).setMidnight().create(), new DateBuilder().add(2, -1).setLastDayOfMonth().setMidnight().add(13, 86399).create());
            }
            case 3: {
                return new TimePeriod(TimeFrameType.FIXED, 0, null, new DateBuilder().add(3, -1).set(7, 2).setMidnight().create(), new DateBuilder().set(7, 2).setMidnight().add(13, -1).create());
            }
            case 7: {
                return new TimePeriod(TimeFrameType.FIXED, 0, null, new DateBuilder().add(1, -1).set(6, 1).setMidnight().create(), new DateBuilder().set(6, 1).setMidnight().add(13, -1).create());
            }
            case 4: {
                return new TimePeriod(TimeFrameType.FIXED, 0, null, new DateBuilder().set(5, 1).setMidnight().create(), new Date());
            }
            case 2: {
                return new TimePeriod(TimeFrameType.FIXED, 0, null, new DateBuilder().set(7, 2).setMidnight().create(), new Date());
            }
            case 6: {
                return new TimePeriod(TimeFrameType.FIXED, 0, null, new DateBuilder().set(6, 1).setMidnight().create(), new Date());
            }
            case 0: {
                return new TimePeriod(TimeFrameType.FIXED, 0, null, new DateBuilder().setMidnight().create(), new Date());
            }
            case 1: {
                return new TimePeriod(TimeFrameType.FIXED, 0, null, new DateBuilder().setMidnight().add(5, -1).create(), new DateBuilder().setMidnight().add(13, -1).create());
            }
        }
        return null;
    }
}

