/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.datacollection.ChartDciConfig;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.datacollection.GraphDefinition;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objecttools.ObjectContextBase;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.views.ViewPlacement;
import org.netxms.nxmc.modules.datacollection.views.HistoricalGraphView;
import org.netxms.nxmc.modules.objects.ObjectContext;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class GraphTemplateCache {
    private static final Logger logger = LoggerFactory.getLogger(GraphTemplateCache.class);
    private NXCSession session = null;
    private List<GraphDefinition> templateList = new ArrayList();

    public GraphTemplateCache(NXCSession session) {
        this.session = session;
        this.reload();
        session.addListener((SessionListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public static void attachSession(Display display, NXCSession session) {
        GraphTemplateCache instance = new GraphTemplateCache(session);
        Registry.setSingleton((Display)display, GraphTemplateCache.class, (Object)instance);
    }

    public static GraphTemplateCache getInstance() {
        return (GraphTemplateCache)Registry.getSingleton(GraphTemplateCache.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reload() {
        try {
            List list = this.templateList;
            synchronized (list) {
                this.templateList.clear();
                this.templateList = this.session.getPredefinedGraphs(true);
            }
        }
        catch (Exception e) {
            logger.error("Exception in ObjectToolsCache.reload()", (Throwable)e);
        }
    }

    public GraphDefinition[] getGraphTemplates() {
        GraphDefinition[] graphs = this.templateList.toArray(new GraphDefinition[this.templateList.size()]);
        Arrays.sort(graphs, (gd1, gd2) -> gd1.getName().replace("&", "").compareToIgnoreCase(gd2.getName().replace("&", "")));
        return graphs;
    }

    public static void instantiate(AbstractNode node, long contextId, GraphDefinition template, DciValue[] dciList, NXCSession session, ViewPlacement viewPlacement) throws IOException, NXCException {
        ArrayList<String> textsToExpand = new ArrayList<String>();
        textsToExpand.add(template.getTitle());
        String name = (String)session.substituteMacros((ObjectContextBase)new ObjectContext((AbstractObject)node, null, contextId), textsToExpand, new HashMap()).get(0);
        GraphDefinition graphDefinition = new GraphDefinition(template, name);
        HashSet<ChartDciConfig> chartMetrics = new HashSet<ChartDciConfig>();
        block0: for (ChartDciConfig dci : graphDefinition.getDciList()) {
            if (dci.regexMatch) {
                Pattern namePattern = Pattern.compile(dci.dciName);
                Pattern descriptionPattern = Pattern.compile(dci.dciDescription);
                Pattern tagPattern = Pattern.compile(dci.dciTag);
                for (DciValue dciInfo : dciList) {
                    if (dciInfo.getDcObjectType() != 1) continue;
                    Matcher matcher = null;
                    boolean match = false;
                    if (!dci.dciName.isEmpty()) {
                        matcher = namePattern.matcher(dciInfo.getName());
                        match = matcher.find();
                    }
                    if (!match && !dci.dciDescription.isEmpty()) {
                        matcher = descriptionPattern.matcher(dciInfo.getDescription());
                        match = matcher.find();
                    }
                    if (!match && !dci.dciTag.isEmpty()) {
                        matcher = tagPattern.matcher(dciInfo.getUserTag());
                        match = matcher.find();
                    }
                    if (!match) continue;
                    chartMetrics.add(new ChartDciConfig(dci, matcher, dciInfo));
                    if (!dci.multiMatch) continue block0;
                }
                continue;
            }
            for (DciValue dciInfo : dciList) {
                if (dciInfo.getDcObjectType() != 1 || !(!dci.dciName.isEmpty() && dciInfo.getName().equalsIgnoreCase(dci.dciName) || !dci.dciDescription.isEmpty() && dciInfo.getDescription().equalsIgnoreCase(dci.dciDescription)) && (dci.dciTag.isEmpty() || !dciInfo.getUserTag().equalsIgnoreCase(dci.dciTag))) continue;
                chartMetrics.add(new ChartDciConfig(dci, dciInfo));
                if (!dci.multiMatch) continue block0;
            }
        }
        Display display = viewPlacement.getWindow().getShell().getDisplay();
        if (!chartMetrics.isEmpty()) {
            display.syncExec(() -> {
                graphDefinition.setDciList(chartMetrics.toArray(new ChartDciConfig[chartMetrics.size()]));
                GraphTemplateCache.showPredefinedGraph((GraphDefinition)graphDefinition, (AbstractNode)node, (long)contextId, (ViewPlacement)viewPlacement);
            });
        } else {
            display.syncExec(() -> MessageDialogHelper.openError((Shell)viewPlacement.getWindow().getShell(), (String)"Error", (String)"None of template DCI were found on a node."));
        }
    }

    private static void showPredefinedGraph(GraphDefinition graphDefinition, AbstractNode node, long contextId, ViewPlacement viewPlacement) {
        HistoricalGraphView view = new HistoricalGraphView((AbstractObject)node, Arrays.asList(graphDefinition.getDciList()), null, contextId);
        viewPlacement.openView((View)view);
        view.initPredefinedGraph(graphDefinition);
    }
}

