/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.dialogs;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.DataOrigin;
import org.netxms.client.constants.DataType;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Template;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.dialogs.IParameterSelectionDialog;
import org.netxms.nxmc.modules.datacollection.dialogs.helpers.StringFilter;
import org.netxms.nxmc.modules.objects.dialogs.ObjectSelectionDialog;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class SelectSmclpDlg
extends Dialog
implements IParameterSelectionDialog {
    private final I18n i18n = LocalizationHelper.getI18n(SelectSmclpDlg.class);
    private static final String SETTINGS_PREFIX = "SelectAgentParamDlg." + String.valueOf(DataOrigin.SMCLP);
    private Button queryButton;
    private Action actionQuery;
    private AbstractObject queryObject;
    protected boolean selectTables;
    protected AbstractObject object;
    protected Text filterText;
    protected SortableTableViewer viewer;
    protected Object selection;
    protected StringFilter filter;

    public SelectSmclpDlg(Shell parentShell, long nodeId) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.queryObject = this.object = Registry.getSession().findObjectById(nodeId);
        this.actionQuery = new /* Unavailable Anonymous Inner Class!! */;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.i18n.tr("Parameter Selection"));
        PreferenceStore settings = PreferenceStore.getInstance();
        try {
            newShell.setSize(settings.getAsPoint(SETTINGS_PREFIX + ".size", 600, 400));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        Label label = new Label(dialogArea, 0);
        label.setText(this.selectTables ? this.i18n.tr("Available tables") : this.i18n.tr("Available parameters"));
        this.filterText = new Text(dialogArea, 2048);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.filterText.setLayoutData((Object)gd);
        this.filterText.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        String[] names = new String[]{this.i18n.tr("Property")};
        int[] widths = new int[]{350};
        this.viewer = new SortableTableViewer(dialogArea, names, widths, 0, 128, 67584);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (String)(SETTINGS_PREFIX + ".viewer"));
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.viewer.setComparator(new ViewerComparator());
        this.filter = new StringFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.viewer.getTable().addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.getTable().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createPopupMenu();
        gd = new GridData();
        gd.heightHint = 250;
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.viewer.getControl().setLayoutData((Object)gd);
        this.fillList();
        return dialogArea;
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void okPressed() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("You must select parameter from the list!"));
            return;
        }
        this.selection = selection.getFirstElement();
        this.saveSettings();
        super.okPressed();
    }

    protected void cancelPressed() {
        this.saveSettings();
        super.cancelPressed();
    }

    protected void saveSettings() {
        Point size = this.getShell().getSize();
        PreferenceStore settings = PreferenceStore.getInstance();
        settings.set(SETTINGS_PREFIX + ".size", size);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        ++((GridLayout)parent.getLayout()).numColumns;
        this.queryButton = new Button(parent, 8);
        this.queryButton.setText(this.i18n.tr("&Query..."));
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.queryButton.setLayoutData((Object)gd);
        this.queryButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        super.createButtonsForButtonBar(parent);
    }

    protected void fillList() {
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    protected void querySelectedParameter() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        if (this.queryObject instanceof Template) {
            ObjectSelectionDialog sDlg = new ObjectSelectionDialog(this.getShell(), ObjectSelectionDialog.createNodeSelectionFilter((boolean)false));
            sDlg.enableMultiSelection(false);
            if (sDlg.open() == 0) {
                this.queryObject = (AbstractObject)sDlg.getSelectedObjects().get(0);
            }
        }
        String n = (String)selection.getFirstElement();
        NXCSession session = Registry.getSession();
        String name = n;
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public DataType getParameterDataType() {
        return DataType.STRING;
    }

    public String getParameterDescription() {
        return (String)this.selection;
    }

    public String getParameterName() {
        return (String)this.selection;
    }

    public String getInstanceColumn() {
        return "";
    }
}

