/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.propertypages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.client.datacollection.PredictionEngine;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.DataCollectionObjectEditor;
import org.netxms.nxmc.modules.datacollection.propertypages.AbstractDCIPropertyPage;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class Analytics
extends AbstractDCIPropertyPage {
    private final I18n i18n = LocalizationHelper.getI18n(Analytics.class);
    private DataCollectionItem dci;
    private Combo predictionEngine;
    private List<PredictionEngine> engines;

    public Analytics(DataCollectionObjectEditor editor) {
        super(LocalizationHelper.getI18n(Analytics.class).tr("Analytics"), editor);
        try {
            this.engines = Registry.getSession().getPredictionEngines();
        }
        catch (Exception e) {
            this.engines = new ArrayList(0);
        }
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = (Composite)super.createContents(parent);
        this.dci = this.editor.getObjectAsItem();
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.predictionEngine = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)this.i18n.tr("Prediction engine"), (Object)new GridData(4, 0x1000000, true, false));
        this.predictionEngine.add("None");
        for (PredictionEngine e : this.engines) {
            this.predictionEngine.add(e.getDescription());
            if (!e.getName().equals(this.dci.getPredictionEngine())) continue;
            this.predictionEngine.select(this.predictionEngine.getItemCount() - 1);
        }
        if (this.predictionEngine.getSelectionIndex() == -1) {
            this.predictionEngine.select(0);
        }
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        int index = this.predictionEngine.getSelectionIndex();
        this.dci.setPredictionEngine(index > 0 ? ((PredictionEngine)this.engines.get(index - 1)).getName() : "");
        this.editor.modify();
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.predictionEngine.select(0);
    }
}

