/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.propertypages;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.netxms.client.constants.DataOrigin;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.client.datacollection.DataCollectionObject;
import org.netxms.client.snmp.SnmpVersion;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.DataCollectionObjectEditor;
import org.netxms.nxmc.modules.datacollection.propertypages.AbstractDCIPropertyPage;
import org.netxms.nxmc.modules.datacollection.propertypages.SNMP;
import org.xnap.commons.i18n.I18n;

/*
 * Exception performing whole class analysis ignored.
 */
public class SNMP
extends AbstractDCIPropertyPage {
    private final I18n i18n = LocalizationHelper.getI18n(SNMP.class);
    private static final String[] snmpRawTypes = new String[]{LocalizationHelper.getI18n(SNMP.class).tr("None"), LocalizationHelper.getI18n(SNMP.class).tr("32-bit signed integer"), LocalizationHelper.getI18n(SNMP.class).tr("32-bit unsigned integer"), LocalizationHelper.getI18n(SNMP.class).tr("64-bit signed integer"), LocalizationHelper.getI18n(SNMP.class).tr("64-bit unsigned integer"), LocalizationHelper.getI18n(SNMP.class).tr("Floating point number"), LocalizationHelper.getI18n(SNMP.class).tr("IPv4 address"), LocalizationHelper.getI18n(SNMP.class).tr("MAC address"), LocalizationHelper.getI18n(SNMP.class).tr("IPv6 address")};
    private DataCollectionObject dco;
    private Button checkInterpretRawSnmpValue;
    private Combo snmpRawType;
    private Button checkUseCustomSnmpPort;
    private Spinner customSnmpPort;
    private Button checkUseCustomSnmpVersion;
    private Combo customSnmpVersion;

    public SNMP(DataCollectionObjectEditor editor) {
        super(LocalizationHelper.getI18n(SNMP.class).tr("SNMP"), editor);
    }

    protected Control createContents(Composite parent) {
        Composite pageArea = (Composite)super.createContents(parent);
        this.dco = this.editor.getObject();
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        pageArea.setLayout((Layout)layout);
        GridData gd = null;
        if (this.dco instanceof DataCollectionItem) {
            this.checkInterpretRawSnmpValue = new Button(pageArea, 32);
            this.checkInterpretRawSnmpValue.setText(this.i18n.tr("Interpret SNMP octet string raw value as"));
            this.checkInterpretRawSnmpValue.setSelection(((DataCollectionItem)this.dco).isSnmpRawValueInOctetString());
            this.checkInterpretRawSnmpValue.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            this.snmpRawType = new Combo(pageArea, 2056);
            for (int i = 0; i < snmpRawTypes.length; ++i) {
                this.snmpRawType.add(snmpRawTypes[i]);
            }
            this.snmpRawType.select(((DataCollectionItem)this.dco).getSnmpRawValueType());
            this.snmpRawType.setEnabled(this.dco.getOrigin() == DataOrigin.SNMP && ((DataCollectionItem)this.dco).isSnmpRawValueInOctetString());
            gd = new GridData();
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalAlignment = 4;
            this.snmpRawType.setLayoutData((Object)gd);
        }
        this.checkUseCustomSnmpPort = new Button(pageArea, 32);
        this.checkUseCustomSnmpPort.setText(this.i18n.tr("Use custom SNMP port:"));
        this.checkUseCustomSnmpPort.setSelection(this.dco.getSnmpPort() != 0);
        this.checkUseCustomSnmpPort.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.customSnmpPort = new Spinner(pageArea, 2048);
        this.customSnmpPort.setMinimum(1);
        this.customSnmpPort.setMaximum(65535);
        if (this.dco.getOrigin() == DataOrigin.SNMP && this.dco.getSnmpPort() != 0) {
            this.customSnmpPort.setEnabled(true);
            this.customSnmpPort.setSelection(this.dco.getSnmpPort());
        } else {
            this.customSnmpPort.setEnabled(false);
        }
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.customSnmpPort.setLayoutData((Object)gd);
        this.checkUseCustomSnmpVersion = new Button(pageArea, 32);
        this.checkUseCustomSnmpVersion.setText("Use custom SNMP version:");
        this.checkUseCustomSnmpVersion.setSelection(this.dco.getSnmpVersion() != SnmpVersion.DEFAULT);
        this.checkUseCustomSnmpVersion.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.customSnmpVersion = new Combo(pageArea, 2056);
        this.customSnmpVersion.add("1");
        this.customSnmpVersion.add("2c");
        this.customSnmpVersion.add("3");
        this.customSnmpVersion.select(SNMP.indexFromSnmpVersion((SnmpVersion)this.dco.getSnmpVersion()));
        this.customSnmpVersion.setEnabled(this.dco.getSnmpVersion() != SnmpVersion.DEFAULT);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.customSnmpVersion.setLayoutData((Object)gd);
        return pageArea;
    }

    private static int indexFromSnmpVersion(SnmpVersion version) {
        switch (4.$SwitchMap$org$netxms$client$snmp$SnmpVersion[version.ordinal()]) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
        }
        return -1;
    }

    private static SnmpVersion indexToSnmpVersion(int index) {
        switch (index) {
            case 0: {
                return SnmpVersion.V1;
            }
            case 1: {
                return SnmpVersion.V2C;
            }
            case 2: {
                return SnmpVersion.V3;
            }
        }
        return SnmpVersion.DEFAULT;
    }

    protected boolean applyChanges(boolean isApply) {
        if (this.dco instanceof DataCollectionItem) {
            ((DataCollectionItem)this.dco).setSnmpRawValueInOctetString(this.checkInterpretRawSnmpValue.getSelection());
            ((DataCollectionItem)this.dco).setSnmpRawValueType(this.snmpRawType.getSelectionIndex());
        }
        if (this.checkUseCustomSnmpPort.getSelection()) {
            this.dco.setSnmpPort(this.customSnmpPort.getSelection());
        } else {
            this.dco.setSnmpPort(0);
        }
        if (this.checkUseCustomSnmpVersion.getSelection()) {
            this.dco.setSnmpVersion(SNMP.indexToSnmpVersion((int)this.customSnmpVersion.getSelectionIndex()));
        } else {
            this.dco.setSnmpVersion(SnmpVersion.DEFAULT);
        }
        this.editor.modify();
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        if (this.dco instanceof DataCollectionItem) {
            this.checkInterpretRawSnmpValue.setSelection(false);
        }
        this.checkUseCustomSnmpPort.setSelection(false);
        this.customSnmpPort.setSelection(161);
    }
}

