/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.propertypages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.client.datacollection.Threshold;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.DataCollectionObjectEditor;
import org.netxms.nxmc.modules.datacollection.dialogs.EditThresholdDialog;
import org.netxms.nxmc.modules.datacollection.propertypages.AbstractDCIPropertyPage;
import org.netxms.nxmc.modules.datacollection.widgets.helpers.ThresholdLabelProvider;
import org.netxms.nxmc.modules.events.widgets.EventSelector;
import org.xnap.commons.i18n.I18n;

public class Thresholds
extends AbstractDCIPropertyPage {
    private final I18n i18n = LocalizationHelper.getI18n(Thresholds.class);
    public static final int COLUMN_OPERATION = 0;
    public static final int COLUMN_EVENT = 1;
    public static final int COLUMN_DEACTIVATION_EVENT = 2;
    private DataCollectionItem dci;
    private List<Threshold> thresholds;
    private LabeledText instance;
    private Button checkDetectAnomalies;
    private Button checkAllThresholds;
    private SortableTableViewer thresholdList;
    private Button addButton;
    private Button modifyButton;
    private Button deleteButton;
    private Button upButton;
    private Button downButton;
    private Button duplicateButton;
    private EventSelector rearmEventSelector;

    public Thresholds(DataCollectionObjectEditor editor) {
        super(LocalizationHelper.getI18n(Thresholds.class).tr("Thresholds"), editor);
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = (Composite)super.createContents(parent);
        this.dci = this.editor.getObjectAsItem();
        this.thresholds = new ArrayList(this.dci.getThresholds().size());
        for (Threshold t : this.dci.getThresholds()) {
            this.thresholds.add(new Threshold(t));
        }
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.instance = new LabeledText(dialogArea, 0);
        this.instance.setLabel(this.i18n.tr("Instance name"));
        this.instance.setText(this.dci.getInstanceName());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.instance.setLayoutData((Object)gd);
        if (this.dci.getTemplateId() == this.dci.getNodeId()) {
            this.instance.getTextControl().setEditable(false);
        }
        this.checkDetectAnomalies = new Button(dialogArea, 32);
        this.checkDetectAnomalies.setText(this.i18n.tr("Detect anomalies"));
        this.checkDetectAnomalies.setSelection(this.dci.isAnomalyDetectionEnabled());
        this.checkAllThresholds = new Button(dialogArea, 32);
        this.checkAllThresholds.setText(this.i18n.tr("Process all thresholds"));
        this.checkAllThresholds.setSelection(this.dci.isProcessAllThresholds());
        Composite thresholdArea = new Composite(dialogArea, 0);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = 2;
        thresholdArea.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.verticalSpacing = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        thresholdArea.setLayout((Layout)layout);
        new Label(thresholdArea, 0).setText(this.i18n.tr("Thresholds"));
        this.thresholdList = new SortableTableViewer(thresholdArea, 68354);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = 2;
        this.thresholdList.getControl().setLayoutData((Object)gd);
        this.setupThresholdList();
        this.thresholdList.setInput((Object)this.thresholds.toArray());
        this.thresholdList.packColumns();
        Composite leftButtons = new Composite(thresholdArea, 0);
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        leftButtons.setLayoutData((Object)gd);
        RowLayout buttonsLayout = new RowLayout(256);
        buttonsLayout.marginBottom = 0;
        buttonsLayout.marginLeft = 0;
        buttonsLayout.marginRight = 0;
        buttonsLayout.marginTop = 0;
        buttonsLayout.spacing = 4;
        buttonsLayout.fill = true;
        buttonsLayout.pack = false;
        leftButtons.setLayout((Layout)buttonsLayout);
        this.upButton = new Button(leftButtons, 8);
        this.upButton.setText(this.i18n.tr("&Up"));
        this.upButton.setEnabled(false);
        this.upButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.downButton = new Button(leftButtons, 8);
        this.downButton.setText(this.i18n.tr("&Down"));
        this.downButton.setEnabled(false);
        this.downButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Composite buttons = new Composite(thresholdArea, 0);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        buttons.setLayoutData((Object)gd);
        buttonsLayout = new RowLayout(256);
        buttonsLayout.marginBottom = 0;
        buttonsLayout.marginLeft = 0;
        buttonsLayout.marginRight = 0;
        buttonsLayout.marginTop = 0;
        buttonsLayout.spacing = 4;
        buttonsLayout.fill = true;
        buttonsLayout.pack = false;
        buttons.setLayout((Layout)buttonsLayout);
        this.addButton = new Button(buttons, 8);
        this.addButton.setText(this.i18n.tr("&Add..."));
        RowData rd = new RowData();
        rd.width = 90;
        this.addButton.setLayoutData((Object)rd);
        this.addButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.duplicateButton = new Button(buttons, 8);
        this.duplicateButton.setText(this.i18n.tr("Du&plicate"));
        rd = new RowData();
        rd.width = 90;
        this.duplicateButton.setLayoutData((Object)rd);
        this.duplicateButton.setEnabled(false);
        this.duplicateButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.modifyButton = new Button(buttons, 8);
        this.modifyButton.setText(this.i18n.tr("&Edit..."));
        rd = new RowData();
        rd.width = 90;
        this.modifyButton.setLayoutData((Object)rd);
        this.modifyButton.setEnabled(false);
        this.modifyButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.deleteButton = new Button(buttons, 8);
        this.deleteButton.setText(this.i18n.tr("De&lete"));
        rd = new RowData();
        rd.width = 90;
        this.deleteButton.setLayoutData((Object)rd);
        this.deleteButton.setEnabled(false);
        this.deleteButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.rearmEventSelector = new EventSelector(dialogArea, 0);
        this.rearmEventSelector.setLabel(this.i18n.tr("Generate event when all thresholds are deactivated"));
        this.rearmEventSelector.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.rearmEventSelector.setEventCode(this.dci.getAllThresholdsRearmEvent());
        this.thresholdList.addSelectionChangedListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            int index = this.thresholds.indexOf(selection.getFirstElement());
            this.upButton.setEnabled(selection.size() == 1 && index > 0);
            this.downButton.setEnabled(selection.size() == 1 && index >= 0 && index < this.thresholds.size() - 1);
            this.modifyButton.setEnabled(selection.size() == 1);
            this.deleteButton.setEnabled(selection.size() > 0);
            this.duplicateButton.setEnabled(selection.size() > 0);
        });
        this.thresholdList.addDoubleClickListener(e -> this.editThreshold());
        return dialogArea;
    }

    private void deleteThresholds() {
        IStructuredSelection selection = this.thresholdList.getStructuredSelection();
        if (!selection.isEmpty()) {
            Iterator it = selection.iterator();
            while (it.hasNext()) {
                this.thresholds.remove(it.next());
            }
            this.thresholdList.setInput((Object)this.thresholds.toArray());
            this.thresholdList.packColumns();
        }
    }

    private void editThreshold() {
        IStructuredSelection selection = this.thresholdList.getStructuredSelection();
        if (selection.size() == 1) {
            Threshold threshold = (Threshold)selection.getFirstElement();
            EditThresholdDialog dlg = new EditThresholdDialog(this.getShell(), threshold);
            if (dlg.open() == 0) {
                this.thresholdList.update((Object)threshold, null);
                this.thresholdList.packColumns();
            }
        }
    }

    private void addThreshold() {
        Threshold threshold = new Threshold();
        EditThresholdDialog dlg = new EditThresholdDialog(this.getShell(), threshold);
        if (dlg.open() == 0) {
            this.thresholds.add(threshold);
            this.thresholdList.setInput((Object)this.thresholds.toArray());
            this.thresholdList.packColumns();
            this.thresholdList.setSelection((ISelection)new StructuredSelection((Object)threshold));
        }
    }

    private void duplicateThreshold() {
        IStructuredSelection selection = (IStructuredSelection)this.thresholdList.getSelection();
        if (selection.size() > 0) {
            List list = selection.toList();
            for (Threshold t : list) {
                this.thresholds.add(this.thresholds.indexOf(t) + 1, t.duplicate());
                this.thresholdList.setInput((Object)this.thresholds.toArray());
            }
        }
    }

    private void moveUp() {
        Threshold threshold;
        int index;
        IStructuredSelection selection = (IStructuredSelection)this.thresholdList.getSelection();
        if (selection.size() == 1 && (index = this.thresholds.indexOf(threshold = (Threshold)selection.getFirstElement())) > 0) {
            Collections.swap(this.thresholds, index - 1, index);
            this.thresholdList.setInput((Object)this.thresholds.toArray());
            this.thresholdList.setSelection((ISelection)new StructuredSelection((Object)threshold));
        }
    }

    private void moveDown() {
        Threshold threshold;
        int index;
        IStructuredSelection selection = (IStructuredSelection)this.thresholdList.getSelection();
        if (selection.size() == 1 && (index = this.thresholds.indexOf(threshold = (Threshold)selection.getFirstElement())) < this.thresholds.size() - 1 && index >= 0) {
            Collections.swap(this.thresholds, index + 1, index);
            this.thresholdList.setInput((Object)this.thresholds.toArray());
            this.thresholdList.setSelection((ISelection)new StructuredSelection((Object)threshold));
        }
    }

    private void setupThresholdList() {
        Table table = this.thresholdList.getTable();
        TableColumn column = new TableColumn(table, 16384);
        column.setText(this.i18n.tr("Expression"));
        column = new TableColumn(table, 16384);
        column.setText(this.i18n.tr("Activation event"));
        column = new TableColumn(table, 16384);
        column.setText(this.i18n.tr("Deactivation event"));
        this.thresholdList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.thresholdList.setLabelProvider((IBaseLabelProvider)new ThresholdLabelProvider());
        this.thresholdList.disableSorting();
    }

    protected boolean applyChanges(boolean isApply) {
        this.dci.setInstanceName(this.instance.getText());
        this.dci.setAnomalyDetectionEnabled(this.checkDetectAnomalies.getSelection());
        this.dci.setProcessAllThresholds(this.checkAllThresholds.getSelection());
        this.dci.getThresholds().clear();
        this.dci.getThresholds().addAll(this.thresholds);
        this.dci.setAllThresholdsRearmEvent(this.rearmEventSelector.getEventCode());
        this.editor.modify();
        return true;
    }
}

