/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.propertypages.helpers;

import java.util.HashMap;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.constants.DataType;
import org.netxms.client.datacollection.ColumnDefinition;
import org.netxms.client.snmp.SnmpObjectId;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.widgets.helpers.DataCollectionDisplayInfo;
import org.xnap.commons.i18n.I18n;

public class TableColumnLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private final I18n i18n = LocalizationHelper.getI18n(TableColumnLabelProvider.class);
    private HashMap<Integer, String> afTexts = new HashMap();

    public TableColumnLabelProvider() {
        this.afTexts.put(1, this.i18n.tr("AVG"));
        this.afTexts.put(3, this.i18n.tr("MAX"));
        this.afTexts.put(2, this.i18n.tr("MIN"));
        this.afTexts.put(0, this.i18n.tr("SUM"));
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return ((ColumnDefinition)element).getName();
            }
            case 1: {
                return ((ColumnDefinition)element).getDisplayName();
            }
            case 2: {
                return DataCollectionDisplayInfo.getDataTypeName((DataType)((ColumnDefinition)element).getDataType());
            }
            case 3: {
                return ((ColumnDefinition)element).isInstanceColumn() ? this.i18n.tr("Yes") : this.i18n.tr("No");
            }
            case 4: {
                return (String)this.afTexts.get(((ColumnDefinition)element).getAggregationFunction());
            }
            case 5: {
                SnmpObjectId oid = ((ColumnDefinition)element).getSnmpObjectId();
                return oid != null ? oid.toString() : null;
            }
        }
        return null;
    }
}

