/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.datacollection.GraphDefinition;
import org.netxms.client.datacollection.GraphFolder;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.views.NavigationView;
import org.netxms.nxmc.base.views.helpers.GraphTreeContentProvider;
import org.netxms.nxmc.base.views.helpers.GraphTreeFilter;
import org.netxms.nxmc.base.views.helpers.GraphTreeLabelProvider;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.views.HistoricalGraphView;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public final class GraphBrowser
extends NavigationView
implements SessionListener {
    final I18n i18n = LocalizationHelper.getI18n(GraphBrowser.class);
    private TreeViewer viewer;
    private NXCSession session = Registry.getSession();
    private GraphFolder root;
    private Action actionProperties;
    private Action actionDelete;

    public GraphBrowser() {
        super(LocalizationHelper.getI18n(GraphBrowser.class).tr("Graphs"), null, "Graphs", true, false, false);
    }

    protected void createContent(Composite parent) {
        this.viewer = new TreeViewer(parent, 0);
        this.viewer.setContentProvider((IContentProvider)new GraphTreeContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new GraphTreeLabelProvider());
        this.viewer.setComparator((ViewerComparator)new /* Unavailable Anonymous Inner Class!! */);
        GraphTreeFilter filter = new GraphTreeFilter();
        this.viewer.addFilter((ViewerFilter)filter);
        this.setFilterClient((ISelectionProvider)this.viewer, (AbstractViewerFilter)filter);
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.session.addListener((SessionListener)this);
        this.createActions();
        this.createPopupMenu();
        this.refresh();
    }

    private void createActions() {
        this.actionDelete = new /* Unavailable Anonymous Inner Class!! */;
        this.actionProperties = new /* Unavailable Anonymous Inner Class!! */;
    }

    public void dispose() {
        this.session.removeListener((SessionListener)this);
        super.dispose();
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        ITreeSelection selection = this.viewer.getStructuredSelection();
        if (selection.getFirstElement() instanceof GraphFolder) {
            return;
        }
        mgr.add((IAction)this.actionDelete);
        if (selection.size() == 1) {
            mgr.add((IContributionItem)new Separator());
            mgr.add((IAction)this.actionProperties);
        }
    }

    private void editPredefinedGraph() {
        ITreeSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        GraphDefinition settings = (GraphDefinition)selection.getFirstElement();
        if (HistoricalGraphView.showGraphPropertyPages((GraphDefinition)settings, (Shell)this.getWindow().getShell())) {
            GraphDefinition newSettings = settings;
            new /* Unavailable Anonymous Inner Class!! */.start();
        }
    }

    private void deletePredefinedGraph() {
        ITreeSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() == 0) {
            return;
        }
        if (!MessageDialogHelper.openQuestion((Shell)this.getWindow().getShell(), (String)this.i18n.tr("Delete Predefined Graphs"), (String)this.i18n.tr("Selected predefined graphs will be deleted. Are you sure?"))) {
            return;
        }
        for (Object o : selection.toList()) {
            if (!(o instanceof GraphDefinition)) continue;
            new /* Unavailable Anonymous Inner Class!! */.start();
        }
    }

    public ISelectionProvider getSelectionProvider() {
        return this.viewer;
    }

    public void setSelection(Object selection) {
        if (selection != null) {
            this.viewer.setSelection((ISelection)new StructuredSelection(selection), true);
        }
    }

    public void refresh() {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public void notificationHandler(SessionNotification n) {
        switch (n.getCode()) {
            case 1028: {
                this.viewer.getControl().getDisplay().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
                break;
            }
            case 1012: {
                if (((GraphDefinition)n.getObject()).isTemplate()) {
                    return;
                }
                this.viewer.getControl().getDisplay().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
    }
}

