/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.events.dialogs;

import java.util.List;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.events.EventTemplate;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.base.dialogs.DialogWithFilter;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.events.widgets.EventTemplateList;
import org.xnap.commons.i18n.I18n;

public class EventSelectionDialog
extends DialogWithFilter {
    private final I18n i18n = LocalizationHelper.getI18n(EventSelectionDialog.class);
    private static final String CONFIG_PREFIX = "SelectEvent";
    private boolean multiSelection;
    private EventTemplate[] selectedEvents;
    private EventTemplateList eventTemplateList;

    public EventSelectionDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.multiSelection = false;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.i18n.tr("Select Event"));
        PreferenceStore settings = PreferenceStore.getInstance();
        int cx = settings.getAsInteger("SelectEvent.cx", 0);
        int cy = settings.getAsInteger("SelectEvent.cy", 0);
        if (cx > 0 && cy > 0) {
            newShell.setSize(cx, cy);
        } else {
            newShell.setSize(600, 460);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        dialogArea.setLayout((Layout)new FillLayout());
        this.eventTemplateList = new EventTemplateList(dialogArea, 0, CONFIG_PREFIX, true);
        this.setFilterClient((StructuredViewer)this.eventTemplateList.getViewer(), this.eventTemplateList.getFilter());
        this.eventTemplateList.getViewer().addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.eventTemplateList.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        return dialogArea;
    }

    protected void okPressed() {
        IStructuredSelection selection = this.eventTemplateList.getViewer().getStructuredSelection();
        List list = selection.toList();
        this.selectedEvents = list.toArray(new EventTemplate[list.size()]);
        super.okPressed();
    }

    public boolean isMultiSelectionEnabled() {
        return this.multiSelection;
    }

    public void enableMultiSelection(boolean enable) {
        this.multiSelection = enable;
    }

    public EventTemplate[] getSelectedEvents() {
        return this.selectedEvents;
    }
}

