/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.events.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.netxms.client.NXCSession;
import org.netxms.client.events.EventProcessingPolicyRule;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.FilterText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.events.dialogs.RuleSelectionDialog;
import org.netxms.nxmc.modules.events.dialogs.helpers.RuleListFilter;
import org.netxms.nxmc.modules.serverconfig.views.helpers.RuleComparator;
import org.netxms.nxmc.modules.serverconfig.views.helpers.RuleLabelProvider;
import org.xnap.commons.i18n.I18n;

public class RuleSelectionDialog
extends Dialog {
    private final I18n i18n = LocalizationHelper.getI18n(RuleSelectionDialog.class);
    private static final String CONFIG_PREFIX = "SelectRule";
    private List<EventProcessingPolicyRule> rulesCache;
    private boolean multiSelection = true;
    private FilterText filterText;
    private TableViewer viewer;
    private RuleListFilter filter;
    private List<EventProcessingPolicyRule> selectedRules = new ArrayList();

    public RuleSelectionDialog(Shell parentShell, List<EventProcessingPolicyRule> rulesCache) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.rulesCache = rulesCache;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.i18n.tr("Select Rule"));
        PreferenceStore settings = PreferenceStore.getInstance();
        int cx = settings.getAsInteger("SelectRule.cx", 600);
        int cy = settings.getAsInteger("SelectRule.cy", 460);
        newShell.setSize(cx, cy);
    }

    protected Control createDialogArea(Composite parent) {
        PreferenceStore settings = PreferenceStore.getInstance();
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.horizontalSpacing = 4;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.filterText = new FilterText(dialogArea, 0, null, false);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.filterText.setLayoutData((Object)gd);
        String filterString = settings.getAsString("SelectRule.Filter");
        if (filterString != null) {
            this.filterText.setText(filterString);
        }
        this.viewer = new TableViewer(dialogArea, 0x10800 | (this.multiSelection ? 2 : 4) | 0x100 | 0x200);
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.getTable().setHeaderVisible(true);
        TableColumn column = new TableColumn(this.viewer.getTable(), 16384);
        column.setText("Rule #");
        column.setWidth(60);
        column = new TableColumn(this.viewer.getTable(), 16384);
        column.setText("Rule Name");
        column.setWidth(250);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator((ViewerComparator)new RuleComparator());
        this.viewer.setLabelProvider((IBaseLabelProvider)new RuleLabelProvider());
        this.filter = new RuleListFilter();
        if (filterString != null) {
            this.filter.setFilterString(filterString);
        }
        this.viewer.addFilter((ViewerFilter)this.filter);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 350;
        this.viewer.getTable().setLayoutData((Object)gd);
        this.filterText.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        if (this.rulesCache == null) {
            this.viewer.getTable().setEnabled(false);
            this.getButton(0).setEnabled(false);
            NXCSession session = Registry.getSession();
            3 job = new /* Unavailable Anonymous Inner Class!! */;
            job.setUser(false);
            job.start();
        } else {
            this.viewer.setInput((Object)this.rulesCache.toArray());
        }
        return dialogArea;
    }

    protected void cancelPressed() {
        this.saveSettings();
        super.cancelPressed();
    }

    protected void okPressed() {
        this.selectedRules = ((IStructuredSelection)this.viewer.getSelection()).toList();
        this.saveSettings();
        super.okPressed();
    }

    private void saveSettings() {
        Point size = this.getShell().getSize();
        PreferenceStore settings = PreferenceStore.getInstance();
        settings.set("SelectRule.cx", size.x);
        settings.set("SelectRule.cy", size.y);
        settings.set("SelectRule.Filter", this.filterText.getText());
    }

    public boolean isMultiSelectionEnabled() {
        return this.multiSelection;
    }

    public void enableMultiSelection(boolean enable) {
        this.multiSelection = enable;
    }

    public List<EventProcessingPolicyRule> getSelectedRules() {
        return this.selectedRules;
    }

    static /* synthetic */ Button access$000(RuleSelectionDialog x0, int x1) {
        return x0.getButton(x1);
    }
}

