/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.events.widgets;

import java.io.Serializable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.AbstractTraceWidget;
import org.netxms.nxmc.base.widgets.helpers.AbstractTraceViewFilter;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.events.widgets.helpers.EventLabelProvider;
import org.netxms.nxmc.modules.events.widgets.helpers.EventMonitorFilter;
import org.xnap.commons.i18n.I18n;

public class EventTraceWidget
extends AbstractTraceWidget
implements SessionListener {
    public static final int COLUMN_TIMESTAMP = 0;
    public static final int COLUMN_SOURCE = 1;
    public static final int COLUMN_SEVERITY = 2;
    public static final int COLUMN_EVENT = 3;
    public static final int COLUMN_MESSAGE = 4;
    private I18n i18n;
    private NXCSession session = Registry.getSession();
    private Action actionShowColor;
    private Action actionShowIcons;
    private EventLabelProvider labelProvider;

    public EventTraceWidget(Composite parent, int style, View view) {
        super(parent, style, view);
        this.session.addListener((SessionListener)this);
        this.addDisposeListener((DisposeListener & Serializable)e -> this.session.removeListener((SessionListener)this));
    }

    protected void setupLocalization() {
        this.i18n = LocalizationHelper.getI18n(EventTraceWidget.class);
    }

    protected void setupViewer(TableViewer viewer) {
        this.labelProvider = new EventLabelProvider();
        viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        PreferenceStore settings = PreferenceStore.getInstance();
        this.labelProvider.setShowColor(settings.getAsBoolean("EventMonitor.showColor", true));
        this.labelProvider.setShowIcons(settings.getAsBoolean("EventMonitor.showIcons", false));
        this.addColumn(this.i18n.tr("Timestamp"), 150);
        this.addColumn(this.i18n.tr("Source"), 200);
        this.addColumn(this.i18n.tr("Severity"), 90);
        this.addColumn(this.i18n.tr("Event"), 200);
        this.addColumn(this.i18n.tr("Message"), 600);
    }

    protected AbstractTraceViewFilter createFilter() {
        return new EventMonitorFilter();
    }

    protected void saveConfig() {
        super.saveConfig();
        PreferenceStore ps = PreferenceStore.getInstance();
        ps.set("EventMonitor.showColor", this.labelProvider.isShowColor());
        ps.set("EventMonitor.showIcons", this.labelProvider.isShowIcons());
    }

    protected String getConfigPrefix() {
        return "EventMonitor";
    }

    protected void createActions() {
        super.createActions();
        this.actionShowColor = new /* Unavailable Anonymous Inner Class!! */;
        this.actionShowColor.setChecked(this.labelProvider.isShowColor());
        this.actionShowIcons = new /* Unavailable Anonymous Inner Class!! */;
        this.actionShowIcons.setChecked(this.labelProvider.isShowIcons());
    }

    public void notificationHandler(SessionNotification n) {
        if (n.getCode() == 2) {
            this.runInUIThread(() -> this.addElement(n.getObject()));
        }
    }

    public Action getActionShowColor() {
        return this.actionShowColor;
    }

    public Action getActionShowIcons() {
        return this.actionShowIcons;
    }
}

