/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.imagelibrary.views;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.LibraryImage;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.ConfigurationView;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.SortableTreeViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.imagelibrary.dialogs.ImagePropertiesDialog;
import org.netxms.nxmc.modules.imagelibrary.views.ImageLibrary;
import org.netxms.nxmc.modules.imagelibrary.views.helpers.ImageCategory;
import org.netxms.nxmc.modules.imagelibrary.views.helpers.ImageLibraryContentProvider;
import org.netxms.nxmc.modules.imagelibrary.views.helpers.ImageLibraryLabelProvider;
import org.netxms.nxmc.modules.imagelibrary.widgets.ImagePreview;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

public class ImageLibrary
extends ConfigurationView {
    private static final Logger logger = LoggerFactory.getLogger(ImageLibrary.class);
    private final I18n i18n = LocalizationHelper.getI18n(ImageLibrary.class);
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_TYPE = 1;
    public static final int COLUMN_PROTECTED = 2;
    public static final int COLUMN_GUID = 3;
    private NXCSession session = Registry.getSession();
    private SessionListener sessionListener;
    private Map<String, ImageCategory> imageCategories = new HashMap();
    private SashForm splitter;
    private SortableTreeViewer viewer;
    private ImagePreview imagePreview;
    private Action actionNew;
    private Action actionEdit;
    private Action actionDelete;
    private Action actionCopy;
    private Action actionSave;

    public ImageLibrary() {
        super(LocalizationHelper.getI18n(ImageLibrary.class).tr("Image Library"), ResourceManager.getImageDescriptor((String)"icons/config-views/image_library.png"), "ImageLibrary", false);
    }

    public void createContent(Composite parent) {
        this.splitter = new SashForm(parent, 256);
        String[] names = new String[]{this.i18n.tr("Name"), this.i18n.tr("MIME type"), this.i18n.tr("Protected"), this.i18n.tr("GUID")};
        int[] widths = new int[]{400, 120, 80, 200};
        this.viewer = new SortableTreeViewer((Composite)this.splitter, names, widths, 0, 128, 67586);
        this.viewer.setContentProvider((IContentProvider)new ImageLibraryContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ImageLibraryLabelProvider());
        this.viewer.setComparator((ViewerComparator)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addDoubleClickListener(e -> {
            ITreeSelection selection = this.viewer.getStructuredSelection();
            if (selection.getFirstElement() instanceof ImageCategory) {
                if (this.viewer.getExpandedState(selection.getFirstElement())) {
                    this.viewer.collapseToLevel(selection.getFirstElement(), -1);
                } else {
                    this.viewer.expandToLevel(selection.getFirstElement(), 1);
                }
            } else if (selection.getFirstElement() instanceof LibraryImage) {
                this.editImage();
            }
        });
        this.viewer.addSelectionChangedListener(e -> {
            ITreeSelection selection = this.viewer.getStructuredSelection();
            if (selection.size() == 1 && selection.getFirstElement() instanceof LibraryImage) {
                this.imagePreview.setImage((LibraryImage)selection.getFirstElement());
                this.actionEdit.setEnabled(true);
                this.actionCopy.setEnabled(true);
                this.actionSave.setEnabled(true);
            } else {
                this.imagePreview.setImage(null);
                this.actionEdit.setEnabled(false);
                this.actionCopy.setEnabled(false);
                this.actionSave.setEnabled(false);
            }
        });
        this.imagePreview = new ImagePreview((Composite)this.splitter, 2048);
        this.splitter.setWeights(new int[]{70, 30});
        this.createActions();
        this.createContextMenu();
        this.sessionListener = new /* Unavailable Anonymous Inner Class!! */;
        this.session.addListener(this.sessionListener);
    }

    protected void postContentCreate() {
        super.postContentCreate();
        this.refresh();
    }

    public void dispose() {
        this.session.removeListener(this.sessionListener);
        super.dispose();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private void createActions() {
        this.actionNew = new /* Unavailable Anonymous Inner Class!! */;
        this.actionEdit = new /* Unavailable Anonymous Inner Class!! */;
        this.actionDelete = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCopy = new /* Unavailable Anonymous Inner Class!! */;
        this.actionSave = new /* Unavailable Anonymous Inner Class!! */;
    }

    private String verifyImageFile(String fileName) throws Exception {
        ImageData image = new ImageData(fileName);
        return switch (image.type) {
            case 0, 1 -> "image/bmp";
            case 2 -> "image/gif";
            case 3 -> "image/x-icon";
            case 4 -> "image/jpeg";
            case 5 -> "image/png";
            case 6 -> "image/tiff";
            default -> "image/unknown";
        };
    }

    private void addImage() {
        ImagePropertiesDialog dialog = new ImagePropertiesDialog(this.getWindow().getShell(), this.imageCategories.keySet());
        ITreeSelection selection = this.viewer.getStructuredSelection();
        if (!selection.isEmpty()) {
            Object o = selection.getFirstElement();
            if (o instanceof ImageCategory) {
                dialog.setDefaultCategory(((ImageCategory)o).getName());
            } else if (o instanceof LibraryImage) {
                dialog.setDefaultCategory(((LibraryImage)o).getCategory());
            }
        }
        if (dialog.open() == 0) {
            this.uploadNewImage(dialog.getName(), dialog.getCategory(), dialog.getFileName());
        }
    }

    private void editImage() {
        ITreeSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        if (selection.getFirstElement() instanceof LibraryImage) {
            LibraryImage image = (LibraryImage)selection.getFirstElement();
            ImagePropertiesDialog dialog = new ImagePropertiesDialog(this.getWindow().getShell(), this.imageCategories.keySet());
            dialog.setName(image.getName());
            dialog.setDefaultCategory(image.getCategory());
            if (dialog.open() == 0) {
                this.doImageUpdate(image, dialog.getName(), dialog.getCategory(), dialog.getFileName());
            }
        }
    }

    private void copyImage() {
        ITreeSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        if (selection.getFirstElement() instanceof LibraryImage) {
            LibraryImage imageDescriptor = (LibraryImage)selection.getFirstElement();
            Image image = ImagePreview.createImageFromDescriptor((Display)this.getDisplay(), (LibraryImage)imageDescriptor);
            if (image != null) {
                WidgetHelper.copyToClipboard((Image)image);
                image.dispose();
            }
        }
    }

    private void saveImage() {
        ITreeSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        if (selection.getFirstElement() instanceof LibraryImage) {
            LibraryImage imageDescriptor = (LibraryImage)selection.getFirstElement();
            Image image = ImagePreview.createImageFromDescriptor((Display)this.getDisplay(), (LibraryImage)imageDescriptor);
            if (image != null) {
                WidgetHelper.saveImageToFile((View)this, (String)(imageDescriptor.getName() + ".png"), (Image)image);
                image.dispose();
            }
        }
    }

    private void doImageUpdate(LibraryImage image, String name, String category, String fileName) {
        if (!image.isProtected()) {
            image.setName(name);
            image.setCategory(category);
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    protected void uploadNewImage(String name, String category, String fileName) {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    protected void deleteImages() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!MessageDialogHelper.openQuestion((Shell)this.getWindow().getShell(), (String)this.i18n.tr("Delete Library Images"), (String)this.i18n.tr("Do you really want to delete selected images?"))) {
            return;
        }
        HashSet<String> categoryDeleteList = new HashSet<String>();
        HashSet<LibraryImage> deleteList = new HashSet<LibraryImage>();
        for (Object o : selection.toList()) {
            if (o instanceof LibraryImage) {
                deleteList.add((LibraryImage)o);
                continue;
            }
            if (!(o instanceof ImageCategory)) continue;
            deleteList.addAll(((ImageCategory)o).getImages());
            categoryDeleteList.add(((ImageCategory)o).getName());
        }
        if (deleteList.isEmpty()) {
            return;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener & Serializable)m -> this.fillContextMenu(m));
        Menu menu = menuManager.createContextMenu((Control)this.viewer.getTree());
        this.viewer.getTree().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionNew);
        ITreeSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() == 1 && selection.getFirstElement() instanceof LibraryImage) {
            manager.add((IAction)this.actionEdit);
        }
        if (!selection.isEmpty()) {
            boolean protectedFound = false;
            for (Object o : selection.toList()) {
                if (o instanceof LibraryImage && ((LibraryImage)o).isProtected()) {
                    protectedFound = true;
                    break;
                }
                if (!(o instanceof ImageCategory) || !((ImageCategory)o).hasProtectedImages()) continue;
                protectedFound = true;
                break;
            }
            if (!protectedFound) {
                manager.add((IAction)this.actionDelete);
            }
        }
        if (selection.size() == 1 && selection.getFirstElement() instanceof LibraryImage) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.actionCopy);
            manager.add((IAction)this.actionSave);
        }
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        super.fillLocalToolBar(manager);
        manager.add((IAction)this.actionNew);
    }

    public void refresh() {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void refreshUI(List<LibraryImage> imageLibrary) {
        this.imageCategories.clear();
        for (LibraryImage image : imageLibrary) {
            ImageCategory category = (ImageCategory)this.imageCategories.get(image.getCategory());
            if (category == null) {
                category = new ImageCategory(image.getCategory());
                this.imageCategories.put(category.getName(), category);
            }
            category.addImage(image);
        }
        this.viewer.setInput((Object)this.imageCategories);
    }

    private void updateImageLocalCopy(UUID guid) {
        12 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    private void removeImageLocalCopy(UUID guid) {
        for (ImageCategory c : this.imageCategories.values()) {
            if (!c.removeImage(guid)) continue;
            this.viewer.refresh();
            break;
        }
    }

    public boolean isModified() {
        return false;
    }

    public void save() {
    }
}

