/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.logviewer.widgets;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.netxms.client.constants.ColumnFilterType;
import org.netxms.client.log.ColumnFilter;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.logviewer.views.helpers.LogLabelProvider;
import org.netxms.nxmc.modules.logviewer.widgets.ConditionEditor;
import org.xnap.commons.i18n.I18n;

public class AssetOperationConditionEditor
extends ConditionEditor {
    private final I18n i18n = LocalizationHelper.getI18n(AssetOperationConditionEditor.class);
    private final String[] OPERATIONS = new String[]{this.i18n.tr("IS"), this.i18n.tr("IS NOT")};
    private Combo actionCombo;

    public AssetOperationConditionEditor(Composite parent) {
        super(parent);
    }

    protected String[] getOperations() {
        return this.OPERATIONS;
    }

    protected void createContent(ColumnFilter initialFilter) {
        String[] assetOperations;
        this.actionCombo = new Combo((Composite)this, 0);
        this.actionCombo.setBackground(this.getBackground());
        GridData gd = new GridData();
        gd.verticalAlignment = 0x1000000;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.actionCombo.setLayoutData((Object)gd);
        for (String operation : assetOperations = LogLabelProvider.getAssetOperationTexts((I18n)this.i18n)) {
            this.actionCombo.add(operation);
        }
        if (initialFilter != null && initialFilter.getType() == ColumnFilterType.EQUALS) {
            this.setSelectedOperation(initialFilter.isNegated() ? 1 : 0);
            this.actionCombo.select((int)initialFilter.getNumericValue());
        }
    }

    public ColumnFilter createFilter() {
        int op = this.getSelectedOperation();
        ColumnFilter filter = new ColumnFilter(ColumnFilterType.EQUALS, (long)this.actionCombo.getSelectionIndex());
        filter.setNegated(op == 1);
        return filter;
    }
}

