/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.logviewer.widgets;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.netxms.client.constants.ColumnFilterType;
import org.netxms.client.constants.Severity;
import org.netxms.client.log.ColumnFilter;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.logviewer.widgets.ConditionEditor;
import org.netxms.nxmc.modules.logviewer.widgets.SeverityConditionEditor;
import org.netxms.nxmc.resources.StatusDisplayInfo;
import org.xnap.commons.i18n.I18n;

public class SeverityConditionEditor
extends ConditionEditor {
    private final I18n i18n = LocalizationHelper.getI18n(SeverityConditionEditor.class);
    private final String[] OPERATIONS = new String[]{this.i18n.tr("IS"), this.i18n.tr("IS NOT"), this.i18n.tr("BELOW"), this.i18n.tr("ABOVE")};
    private Combo severity;

    public SeverityConditionEditor(Composite parent) {
        super(parent);
    }

    protected String[] getOperations() {
        return this.OPERATIONS;
    }

    protected void createContent(ColumnFilter initialFilter) {
        this.severity = new Combo((Composite)this, 2056);
        for (int i = Severity.NORMAL.getValue(); i <= Severity.CRITICAL.getValue(); ++i) {
            this.severity.add(StatusDisplayInfo.getStatusText((int)i));
        }
        this.severity.select(0);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 0x1000000;
        this.severity.setLayoutData((Object)gd);
        if (initialFilter != null) {
            switch (1.$SwitchMap$org$netxms$client$constants$ColumnFilterType[initialFilter.getType().ordinal()]) {
                case 1: {
                    this.setSelectedOperation(initialFilter.isNegated() ? 1 : 0);
                    break;
                }
                case 2: {
                    this.setSelectedOperation(2);
                    break;
                }
                case 3: {
                    this.setSelectedOperation(3);
                    break;
                }
            }
            this.severity.select((int)initialFilter.getNumericValue());
        }
    }

    public ColumnFilter createFilter() {
        switch (this.getSelectedOperation()) {
            case 0: {
                return new ColumnFilter(ColumnFilterType.EQUALS, (long)this.severity.getSelectionIndex());
            }
            case 1: {
                ColumnFilter filter = new ColumnFilter(ColumnFilterType.EQUALS, (long)this.severity.getSelectionIndex());
                filter.setNegated(true);
                return filter;
            }
            case 2: {
                return new ColumnFilter(ColumnFilterType.LESS, (long)this.severity.getSelectionIndex());
            }
            case 3: {
                return new ColumnFilter(ColumnFilterType.GREATER, (long)this.severity.getSelectionIndex());
            }
        }
        return new ColumnFilter(ColumnFilterType.EQUALS, (long)this.severity.getSelectionIndex());
    }
}

