/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.networkmaps.views;

import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.NetworkMap;
import org.netxms.nxmc.Memento;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.views.ViewNotRestoredException;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.networkmaps.views.PredefinedMapView;
import org.xnap.commons.i18n.I18n;

public class AdHocPredefinedMapView
extends PredefinedMapView {
    private final I18n i18n = LocalizationHelper.getI18n(AdHocPredefinedMapView.class);
    private long contextObjectId;
    private NetworkMap map;

    public AdHocPredefinedMapView(long contextObjectId, NetworkMap map) {
        super("objects.predefined-map." + Long.toString(map.getObjectId()));
        this.contextObjectId = contextObjectId;
        this.map = map;
    }

    protected AdHocPredefinedMapView() {
        this.objectMoveLocked = false;
        this.readOnly = true;
    }

    public View cloneView() {
        AdHocPredefinedMapView view = (AdHocPredefinedMapView)super.cloneView();
        view.contextObjectId = this.contextObjectId;
        view.map = this.map;
        return view;
    }

    protected void saveZoom(AbstractObject object) {
    }

    protected void loadZoom(AbstractObject object) {
        PreferenceStore settings = PreferenceStore.getInstance();
        this.viewer.zoomTo(settings.getAsDouble(this.getBaseId() + ".zoom", 1.0));
    }

    public boolean isValidForContext(Object context) {
        return context != null && context instanceof AbstractObject && ((AbstractObject)context).getObjectId() == this.contextObjectId;
    }

    public int getPriority() {
        return 65535;
    }

    public boolean isCloseable() {
        return true;
    }

    public String getName() {
        return super.getName() + " - " + this.map.getObjectName();
    }

    protected Object getContext() {
        return this.map;
    }

    protected void onObjectUpdate(AbstractObject object) {
        if (object.getObjectId() == this.map.getObjectId()) {
            this.map = (NetworkMap)object;
            super.onObjectUpdate(object);
        }
    }

    public void setupMapControl() {
        super.onObjectChange((AbstractObject)this.map);
        super.setupMapControl();
    }

    protected void onObjectChange(AbstractObject object) {
    }

    protected boolean isRelatedObject(long objectId) {
        return this.map.getObjectId() == objectId;
    }

    protected void contextChanged(Object oldContext, Object newContext) {
    }

    public void saveState(Memento memento) {
        super.saveState(memento);
        memento.set("contextObjectId", this.contextObjectId);
        memento.set("map", this.map.getObjectId());
    }

    public void restoreState(Memento memento) throws ViewNotRestoredException {
        super.restoreState(memento);
        this.contextObjectId = memento.getAsLong("contextObjectId", 0L);
        this.map = (NetworkMap)this.session.findObjectById(memento.getAsLong("map", 0L), NetworkMap.class);
        if (this.map == null) {
            throw new ViewNotRestoredException(this.i18n.tr("Invalid map id"));
        }
    }
}

