/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.networkmaps.widgets.helpers;

import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.maps.elements.NetworkMapObject;
import org.netxms.nxmc.modules.networkmaps.widgets.helpers.MapLabelProvider;
import org.netxms.nxmc.modules.networkmaps.widgets.helpers.ObjectFigure;
import org.netxms.nxmc.resources.StatusDisplayInfo;

public class ObjectFloorPlan
extends ObjectFigure {
    private static final int MARGIN_X = 3;
    private static final int MARGIN_Y = 3;
    private static final int TOP_LEFT = 0;
    private static final int TOP_RIGHT = 1;
    private static final int BOTTOM_LEFT = 2;
    private static final int BOTTOM_RIGHT = 3;
    private NetworkMapObject element;
    private boolean resize = true;
    private Label label;
    private int lastX;
    private int lastY;

    public ObjectFloorPlan(NetworkMapObject element, MapLabelProvider labelProvider) {
        super(element, labelProvider);
        this.element = element;
        this.setLayoutManager((LayoutManager)new BorderLayout());
        this.setSize(element.getWidth(), element.getHeight());
        this.label = new Label(this.object.getNameOnMap());
        this.label.setFont(labelProvider.getTitleFont());
        this.label.setLabelAlignment(2);
        this.add((IFigure)this.label);
        Dimension d = this.label.getPreferredSize();
        this.label.setSize(d);
        this.label.setLocation(new Point(element.getWidth() / 2 - d.width / 2, element.getHeight() / 2 - d.height / 2));
        this.setBackgroundColor(StatusDisplayInfo.getStatusColor((ObjectStatus)this.object.getStatus()));
        this.createResizeHandle(3);
    }

    private void createResizeHandle(int pos) {
        Figure handle = new Figure();
        this.add((IFigure)handle);
        Dimension size = this.getSize();
        handle.setSize(8, 8);
        switch (pos) {
            case 0: {
                handle.setLocation(new Point(-1, -1));
                handle.setCursor(Display.getCurrent().getSystemCursor(8));
                break;
            }
            case 1: {
                handle.setLocation(new Point(size.width - 7, -1));
                handle.setCursor(Display.getCurrent().getSystemCursor(6));
                break;
            }
            case 2: {
                handle.setLocation(new Point(-1, size.height - 7));
                handle.setCursor(Display.getCurrent().getSystemCursor(6));
                break;
            }
            case 3: {
                handle.setLocation(new Point(size.width - 7, size.height - 7));
                handle.setCursor(Display.getCurrent().getSystemCursor(8));
            }
        }
        handle.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        handle.addMouseMotionListener((MouseMotionListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void paintFigure(Graphics gc) {
        gc.setAntialias(1);
        Rectangle rect = new Rectangle(this.getBounds());
        ++rect.x;
        ++rect.y;
        rect.width -= 3;
        rect.height -= 3;
        gc.setAlpha(255);
        gc.setForegroundColor(this.isElementSelected() ? SELECTION_COLOR : StatusDisplayInfo.getStatusColor((ObjectStatus)this.object.getStatus()));
        gc.setLineWidth(3);
        gc.setLineStyle(this.isElementSelected() ? 3 : 1);
        gc.drawRoundRectangle(rect, 8, 8);
        if (!this.labelProvider.isTranslucentLabelBackground()) {
            gc.setBackgroundColor(SOLID_WHITE);
            gc.fillRoundRectangle(this.getBounds(), 8, 8);
        }
        gc.setBackgroundColor(this.isElementSelected() ? SELECTION_COLOR : StatusDisplayInfo.getStatusColor((ObjectStatus)this.object.getStatus()));
        gc.setAlpha(32);
        gc.fillRoundRectangle(this.getBounds(), 8, 8);
    }
}

