/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.nxsl.widgets;

import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.NXCSession;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.CompositeWithMessageArea;
import org.netxms.nxmc.keyboard.KeyBindingManager;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.resources.SharedIcons;
import org.netxms.nxmc.resources.ThemeEngine;
import org.xnap.commons.i18n.I18n;

public class ScriptEditor
extends CompositeWithMessageArea {
    private final I18n i18n = LocalizationHelper.getI18n(ScriptEditor.class);
    private Composite content;
    private Text editor;
    private String hintText;
    private Composite hintArea;
    private Text hintTextControl = null;
    private Label hintsExpandButton = null;
    private Button compileButton;
    private KeyBindingManager keyBindingManager;
    private Action actionGoToLine;
    private Action actionSelectAll;
    private Action actionCut;
    private Action actionCopy;
    private Action actionPaste;
    private Action actionDeleteLine;

    public ScriptEditor(Composite parent, int style, int editorStyle) {
        this(parent, style, editorStyle, null, true);
    }

    public ScriptEditor(Composite parent, int style, int editorStyle, String hints) {
        this(parent, style, editorStyle, hints, true);
    }

    public ScriptEditor(Composite parent, int style, int editorStyle, boolean showCompileButton) {
        this(parent, style, editorStyle, null, showCompileButton);
    }

    public ScriptEditor(Composite parent, int style, int editorStyle, String hints, boolean showCompileButton) {
        super(parent, style);
        this.hintText = hints;
        this.content = new Composite((Composite)this, 0);
        this.setContent(this.content);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        this.content.setLayout((Layout)layout);
        if (hints != null) {
            this.createHintsArea();
        }
        this.editor = new Text(this.content, editorStyle | 2);
        this.editor.setData("org.eclipse.rap.rwt.customVariant", (Object)"monospace");
        this.editor.setLayoutData((Object)new GridData(4, 4, true, true));
        this.editor.addTraverseListener((TraverseListener & Serializable)e -> {
            if (e.detail == 16) {
                e.doit = false;
                Point selection = this.editor.getSelection();
                if (selection.x == selection.y) {
                    this.editor.insert("\t");
                    this.editor.setSelection(this.editor.getCaretPosition() + 1);
                } else {
                    String text = this.editor.getText();
                    int startLineOffset = text.lastIndexOf(10, selection.x - 1);
                    startLineOffset = startLineOffset == -1 ? 0 : ++startLineOffset;
                    int endLineOffset = text.indexOf(10, selection.y - 1);
                    if (endLineOffset == -1) {
                        endLineOffset = text.length();
                    }
                    StringBuilder newText = new StringBuilder();
                    int lineStart = startLineOffset;
                    while (lineStart < endLineOffset) {
                        int lineEnd = text.indexOf(10, lineStart);
                        if (lineEnd == -1 || lineEnd > endLineOffset) {
                            lineEnd = endLineOffset;
                        }
                        newText.append("\t").append(text, lineStart, lineEnd);
                        if (lineEnd < endLineOffset) {
                            newText.append('\n');
                        }
                        lineStart = lineEnd + 1;
                    }
                    this.editor.setText(text.substring(0, startLineOffset) + newText.toString() + text.substring(endLineOffset));
                    this.editor.setSelection(selection.x, selection.x + newText.length());
                }
                this.editor.setFocus();
            } else if (e.detail == 8) {
                Point selection = this.editor.getSelection();
                if (selection.x == selection.y) {
                    return;
                }
                e.doit = false;
                String text = this.editor.getText();
                int startLineOffset = text.lastIndexOf(10, selection.x - 1);
                startLineOffset = startLineOffset == -1 ? 0 : ++startLineOffset;
                int endLineOffset = text.indexOf(10, selection.y - 1);
                if (endLineOffset == -1) {
                    endLineOffset = text.length();
                }
                StringBuilder newText = new StringBuilder();
                int lineStart = startLineOffset;
                while (lineStart < endLineOffset) {
                    int lineEnd = text.indexOf(10, lineStart);
                    if (lineEnd == -1 || lineEnd > endLineOffset) {
                        lineEnd = endLineOffset;
                    }
                    if (text.startsWith("\t", lineStart)) {
                        newText.append(text, lineStart + 1, lineEnd);
                    } else {
                        newText.append(text, lineStart, lineEnd);
                    }
                    if (lineEnd < endLineOffset) {
                        newText.append('\n');
                    }
                    lineStart = lineEnd + 1;
                }
                this.editor.setText(text.substring(0, startLineOffset) + newText.toString() + text.substring(endLineOffset));
                this.editor.setSelection(selection.x, selection.x + newText.length());
                this.editor.setFocus();
            }
        });
        if (showCompileButton) {
            Image compileImage = ResourceManager.getImage((String)"icons/compile.png");
            this.compileButton = new Button(this.content, 0x800008);
            this.compileButton.setToolTipText("Compile script");
            this.compileButton.setImage(compileImage);
            this.compileButton.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
            GridData gd = new GridData();
            gd.exclude = true;
            this.compileButton.setLayoutData((Object)gd);
            this.editor.addControlListener((ControlListener)new /* Unavailable Anonymous Inner Class!! */);
            this.compileButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            this.compileButton.setSize(this.compileButton.computeSize(-1, -1));
            this.positionCompileButton();
        }
        this.keyBindingManager = new KeyBindingManager();
        this.createActions();
        this.createContextMenu();
        this.editor.addKeyListener((KeyListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void positionCompileButton() {
        this.compileButton.moveAbove(null);
        Point location = this.editor.getLocation();
        int editorWidth = this.editor.getSize().x;
        ScrollBar sb = this.editor.getVerticalBar();
        if (sb != null) {
            editorWidth -= sb.getSize().x;
        }
        this.compileButton.setLocation(location.x + editorWidth - this.compileButton.getSize().x - 3, location.y + 3);
    }

    private void createHintsArea() {
        this.hintArea = new Composite(this.content, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.numColumns = 2;
        this.hintArea.setLayout((Layout)layout);
        this.hintArea.setLayoutData((Object)new GridData(4, 4, true, false));
        this.hintArea.setBackground(ThemeEngine.getBackgroundColor((String)"MessageBar"));
        CLabel hintsTitle = new CLabel(this.hintArea, 0);
        hintsTitle.setBackground(this.hintArea.getBackground());
        hintsTitle.setForeground(ThemeEngine.getForegroundColor((String)"MessageBar"));
        hintsTitle.setImage(SharedIcons.IMG_INFORMATION);
        hintsTitle.setText(this.i18n.tr("Hints"));
        hintsTitle.setLayoutData((Object)new GridData(4, 4, true, false));
        hintsTitle.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        this.hintsExpandButton = new Label(this.hintArea, 0);
        this.hintsExpandButton.setBackground(this.hintArea.getBackground());
        this.hintsExpandButton.setCursor(this.getDisplay().getSystemCursor(21));
        this.hintsExpandButton.setImage(SharedIcons.IMG_EXPAND);
        this.hintsExpandButton.setToolTipText(this.i18n.tr("Hide message"));
        GridData gd = new GridData();
        gd.verticalAlignment = 0x1000000;
        this.hintsExpandButton.setLayoutData((Object)gd);
        this.hintsExpandButton.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        Label separator = new Label(this.content, 258);
        separator.setLayoutData((Object)new GridData(4, 128, true, false));
    }

    private void createActions() {
        this.actionGoToLine = new /* Unavailable Anonymous Inner Class!! */;
        this.keyBindingManager.addBinding("M1+G", (IAction)this.actionGoToLine);
        this.actionSelectAll = new /* Unavailable Anonymous Inner Class!! */;
        this.keyBindingManager.addBinding("M1+A", (IAction)this.actionSelectAll);
        this.actionDeleteLine = new /* Unavailable Anonymous Inner Class!! */;
        this.keyBindingManager.addBinding("M1+M2+K", (IAction)this.actionDeleteLine);
        this.actionCut = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCut.setEnabled(false);
        this.actionCopy = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCopy.setEnabled(false);
        this.actionPaste = new /* Unavailable Anonymous Inner Class!! */;
        this.actionPaste.setEnabled(false);
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener & Serializable)m -> this.fillContextMenu(m));
        Menu menu = menuMgr.createContextMenu((Control)this.editor);
        this.editor.setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionSelectAll);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionCopy);
        manager.add((IAction)this.actionCut);
        manager.add((IAction)this.actionPaste);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionDeleteLine);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionGoToLine);
        int selectionLength = this.editor.getSelectionCount();
        this.actionCut.setEnabled(selectionLength > 0);
        this.actionCopy.setEnabled(selectionLength > 0);
        this.actionPaste.setEnabled(this.canPaste());
    }

    public Text getTextWidget() {
        return this.editor;
    }

    public void setText(String text) {
        this.editor.setText(text != null ? text : "");
    }

    public String getText() {
        return this.editor.getText();
    }

    public void setFunctions(Set<String> functions) {
    }

    public void addFunctions(Collection<String> fc) {
    }

    public void setVariables(Set<String> variables) {
    }

    public void addVariables(Collection<String> vc) {
    }

    public void setConstants(Set<String> constants) {
    }

    public void addConstants(Collection<String> cc) {
    }

    public String[] getFunctions() {
        return new String[0];
    }

    public String[] getVariables() {
        return new String[0];
    }

    public String[] getConstants() {
        return new String[0];
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point p = this.editor.computeSize(wHint, hHint, changed);
        p.y += 4;
        return p;
    }

    public boolean setFocus() {
        return !this.editor.isDisposed() ? this.editor.setFocus() : super.setFocus();
    }

    public void showLineNumbers(boolean show) {
    }

    private void toggleHints() {
        if (this.hintTextControl != null) {
            this.hintTextControl.dispose();
            this.hintTextControl = null;
            this.hintsExpandButton.setImage(SharedIcons.IMG_EXPAND);
        } else {
            this.hintTextControl = new Text(this.hintArea, 66);
            this.hintTextControl.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            this.hintTextControl.setEditable(false);
            this.hintTextControl.setText(this.hintText);
            this.hintTextControl.setBackground(ThemeEngine.getBackgroundColor((String)"MessageBar"));
            this.hintTextControl.setForeground(ThemeEngine.getForegroundColor((String)"MessageBar"));
            this.hintsExpandButton.setImage(SharedIcons.IMG_COLLAPSE);
        }
        this.layout(true, true);
    }

    public void compileScript() {
        String source = this.getText();
        this.editor.setEditable(false);
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public void goToLine() {
        int maxLine = this.getLineCount();
        InputDialog dlg = new InputDialog(this.getShell(), this.i18n.tr("Go to Line"), String.format(this.i18n.tr("Enter line number (1..%d)"), maxLine), Integer.toString(this.getCurrentLine()), (IInputValidator)new /* Unavailable Anonymous Inner Class!! */);
        if (dlg.open() != 0) {
            return;
        }
        this.setCaretToLine(Integer.parseInt(dlg.getValue()));
    }

    public void highlightErrorLine(int lineNumber) {
    }

    public void highlightWarningLine(int lineNumber) {
    }

    public void clearHighlighting() {
    }

    public int getLineCount() {
        String text = this.editor.getText();
        if (text.isEmpty()) {
            return 0;
        }
        return text.split(this.editor.getLineDelimiter()).length + 1;
    }

    public int getCurrentLine() {
        return this.getLineAtOffset(this.editor.getCaretPosition());
    }

    private int getLineAtOffset(int offset) {
        String text = this.editor.getText().substring(0, offset);
        if (text.isEmpty()) {
            return 0;
        }
        return text.split(this.editor.getLineDelimiter()).length + 1;
    }

    public void setCaretToLine(int lineNumber) {
    }

    public void selectAll() {
        this.editor.selectAll();
    }

    public void deleteLine() {
        int end;
        int start;
        String d = this.editor.getLineDelimiter();
        char de = d.charAt(d.length() - 1);
        String text = this.editor.getText();
        for (start = this.editor.getCaretPosition(); start > 0 && text.charAt(start) != de; --start) {
        }
        if (text.charAt(start) == de) {
            ++start;
        }
        for (end = this.editor.getCaretPosition(); end < text.length() && text.charAt(end) != de; ++end) {
        }
        this.editor.setText(text.substring(0, start) + text.substring(end));
    }

    public void cut() {
        this.editor.cut();
    }

    public void copy() {
        this.editor.copy();
    }

    public void paste() {
        this.editor.paste();
    }

    public boolean canPaste() {
        return true;
    }
}

