/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.views.ViewPlacement;
import org.netxms.nxmc.base.widgets.MessageAreaHolder;

public abstract class ObjectAction<T extends AbstractObject>
extends Action {
    private Class<T> objectClass;
    private ViewPlacement viewPlacement;
    private ISelectionProvider selectionProvider;

    public ObjectAction(Class<T> objectClass, String text, ViewPlacement viewPlacement, ISelectionProvider selectionProvider) {
        super(text);
        this.viewPlacement = viewPlacement;
        this.selectionProvider = selectionProvider;
        this.objectClass = objectClass;
    }

    public boolean isValidForSelection(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        for (Object e : selection.toList()) {
            if (this.objectClass.isInstance(e)) continue;
            return false;
        }
        return true;
    }

    public final void run() {
        ArrayList<AbstractObject> objects = new ArrayList<AbstractObject>();
        for (Object o : ((IStructuredSelection)this.selectionProvider.getSelection()).toList()) {
            if (!this.objectClass.isInstance(o)) continue;
            objects.add((AbstractObject)o);
        }
        if (!objects.isEmpty()) {
            this.run(objects);
        }
    }

    protected abstract void run(List<T> var1);

    protected MessageAreaHolder getMessageArea() {
        return this.viewPlacement.getMessageAreaHolder();
    }

    protected Shell getShell() {
        return this.viewPlacement.getWindow().getShell();
    }

    protected void openView(View view) {
        this.viewPlacement.openView(view);
    }
}

