/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.xnap.commons.i18n.I18n;

public class AttributeEditDialog
extends Dialog {
    private I18n i18n = LocalizationHelper.getI18n(AttributeEditDialog.class);
    private LabeledText textName;
    private LabeledText textValue;
    private Button checkInherite;
    private String name;
    private String value;
    private long flags;
    private boolean inherited;
    private long source;

    public AttributeEditDialog(Shell parentShell, String name, String value, long flags, long source) {
        super(parentShell);
        this.name = name;
        this.value = value;
        this.flags = flags;
        this.inherited = source != 0L;
        this.source = source;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        dialogArea.setLayout((Layout)layout);
        this.textName = new LabeledText(dialogArea, 0);
        this.textName.setLabel(this.i18n.tr("Name"));
        this.textName.getTextControl().setTextLimit(127);
        if (this.name != null) {
            this.textName.setText(this.name);
            this.textName.setEditable(false);
        }
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.textName.setLayoutData((Object)gd);
        this.textValue = new LabeledText(dialogArea, 0);
        this.textValue.setLabel(this.i18n.tr("Value"));
        if (this.value != null) {
            this.textValue.setText(this.value);
        }
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 300;
        this.textValue.setLayoutData((Object)gd);
        if (this.name != null) {
            this.textValue.setFocus();
        }
        this.checkInherite = new Button(dialogArea, 32);
        if (this.inherited) {
            NXCSession session = Registry.getSession();
            this.checkInherite.setText(String.format(this.i18n.tr("Inheritable (enforced by %s [%d])"), session.getObjectName(this.source), this.source));
        } else {
            this.checkInherite.setText(this.i18n.tr("Inheritable"));
        }
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.checkInherite.setLayoutData((Object)gd);
        this.checkInherite.setSelection(this.inherited || (this.flags & 1L) > 0L);
        this.checkInherite.setEnabled(!this.inherited);
        return dialogArea;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.name == null ? this.i18n.tr("Add Attribute") : this.i18n.tr("Modify Attribute"));
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public long getFlags() {
        return this.flags;
    }

    protected void okPressed() {
        this.name = this.textName.getText().trim();
        this.value = this.textValue.getText();
        this.flags = 0L;
        if (this.checkInherite.getSelection()) {
            this.flags |= 1L;
        }
        if (this.inherited) {
            this.flags |= 3L;
        }
        super.okPressed();
    }
}

