/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.dialogs;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.FilterText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.xnap.commons.i18n.I18n;

public class ObjectViewManagerDialog
extends Dialog {
    private final I18n i18n = LocalizationHelper.getI18n(ObjectViewManagerDialog.class);
    private List<View> objectViews;
    private PreferenceStore preferenceStore = PreferenceStore.getInstance();
    private String filterString = null;
    private Map<String, Boolean> changedElements = new HashMap();

    public ObjectViewManagerDialog(Shell parentShell, List<View> objectViews) {
        super(parentShell);
        this.objectViews = objectViews;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.i18n.tr("Object View Manager"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        new Label(dialogArea, 0).setText(this.i18n.tr("Views that are not marked in the list below will not be displayed in object context"));
        Composite listGroup = new Composite(dialogArea, 2048);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        listGroup.setLayout((Layout)layout);
        listGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        FilterText filter = new FilterText(listGroup, 0, null, false, true);
        filter.setLayoutData((Object)new GridData(4, 4, true, false));
        CheckboxTableViewer viewer = CheckboxTableViewer.newCheckList((Composite)listGroup, (int)32);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 400;
        gd.widthHint = 270;
        viewer.getControl().setLayoutData((Object)gd);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new /* Unavailable Anonymous Inner Class!! */);
        viewer.addFilter((ViewerFilter)new /* Unavailable Anonymous Inner Class!! */);
        viewer.setCheckStateProvider((ICheckStateProvider)new /* Unavailable Anonymous Inner Class!! */);
        viewer.addCheckStateListener((ICheckStateListener)new /* Unavailable Anonymous Inner Class!! */);
        viewer.setInput((Object)this.objectViews);
        filter.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        dialogArea.layout(true, true);
        return dialogArea;
    }

    protected void okPressed() {
        for (Map.Entry e : this.changedElements.entrySet()) {
            this.preferenceStore.set("HideView." + (String)e.getKey(), ((Boolean)e.getValue()).booleanValue());
        }
        super.okPressed();
    }
}

