/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.preferencepages;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.base.editors.TimePeriodEditor;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.xnap.commons.i18n.I18n;

public class ObjectsPreferences
extends FieldEditorPreferencePage {
    private final I18n i18n = LocalizationHelper.getI18n(ObjectsPreferences.class);
    private BooleanFieldEditor useServerFilter;
    private Composite autoApplyParent;
    private Composite delayParent;
    private Composite minLengthParent;
    private BooleanFieldEditor autoApply;
    private StringFieldEditor delay;
    private StringFieldEditor minLength;

    public ObjectsPreferences() {
        super(LocalizationHelper.getI18n(ObjectsPreferences.class).tr("Objects"), 0);
        this.setPreferenceStore((IPreferenceStore)PreferenceStore.getInstance());
    }

    protected void createFieldEditors() {
        this.addField((FieldEditor)new BooleanFieldEditor("ObjectsFullSync", this.i18n.tr("&Full object synchronization on startup"), this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("CustomAttributes.ShowHidden", "Show &hidden custom attributes", this.getFieldEditorParent()));
        Group filterGroup = new Group(this.getFieldEditorParent(), 0);
        filterGroup.setText(this.i18n.tr("Filter"));
        filterGroup.getParent().setLayout((Layout)new FillLayout());
        filterGroup.setLayout((Layout)new GridLayout());
        this.useServerFilter = new BooleanFieldEditor("ObjectBrowser.useServerFilterSettings", this.i18n.tr("&Use server settings for object filter"), this.getSubFieldEditorParent(filterGroup));
        this.addField((FieldEditor)this.useServerFilter);
        this.autoApplyParent = this.getSubFieldEditorParent(filterGroup);
        this.autoApply = new BooleanFieldEditor("ObjectBrowser.filterAutoApply", this.i18n.tr("&Apply filter automatically"), this.autoApplyParent);
        this.addField((FieldEditor)this.autoApply);
        this.delayParent = this.getSubFieldEditorParent(filterGroup);
        this.delay = new StringFieldEditor("ObjectBrowser.filterDelay", this.i18n.tr("Filter &delay"), this.delayParent);
        this.addField((FieldEditor)this.delay);
        this.delay.setEmptyStringAllowed(false);
        this.delay.setTextLimit(5);
        this.minLengthParent = this.getSubFieldEditorParent(filterGroup);
        this.minLength = new StringFieldEditor("ObjectBrowser.filterMinLength", this.i18n.tr("Filter &minimal length"), this.minLengthParent);
        this.addField((FieldEditor)this.minLength);
        this.minLength.setEmptyStringAllowed(false);
        this.minLength.setTextLimit(3);
        this.addField((FieldEditor)new TimePeriodEditor("Maintenance.TimeEditor", this.i18n.tr("Predefined maintenance periods"), this.getFieldEditorParent(), "Maintenance.TimeMenuSize", "Maintenance.TimeMenuEntry."));
    }

    private Composite getSubFieldEditorParent(Group group) {
        Composite c = new Composite((Composite)group, 0);
        c.setLayoutData((Object)new GridData(4, 4, true, false));
        return c;
    }

    protected void initialize() {
        super.initialize();
        boolean enabled = !this.useServerFilter.getBooleanValue();
        this.autoApply.setEnabled(enabled, this.autoApplyParent);
        this.delay.setEnabled(enabled, this.delayParent);
        this.minLength.setEnabled(enabled, this.minLengthParent);
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        boolean enabled = !this.useServerFilter.getBooleanValue();
        this.autoApply.setEnabled(enabled, this.autoApplyParent);
        this.delay.setEnabled(enabled, this.delayParent);
        this.minLength.setEnabled(enabled, this.minLengthParent);
    }
}

