/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.propertypages;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.base.GeoLocation;
import org.netxms.base.GeoLocationFormatException;
import org.netxms.base.PostalAddress;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Circuit;
import org.netxms.client.objects.Collector;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.DataCollectionTarget;
import org.netxms.client.objects.Rack;
import org.netxms.client.objects.Zone;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.propertypages.Location;
import org.netxms.nxmc.modules.objects.propertypages.ObjectPropertyPage;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class Location
extends ObjectPropertyPage {
    private I18n i18n = LocalizationHelper.getI18n(Location.class);
    private LabeledText latitude;
    private LabeledText longitude;
    private Button radioTypeUndefined;
    private Button radioTypeManual;
    private Button radioTypeAuto;
    private LabeledText country;
    private LabeledText region;
    private LabeledText city;
    private LabeledText district;
    private LabeledText streetAddress;
    private LabeledText postcode;

    public Location(AbstractObject object) {
        super(LocalizationHelper.getI18n(Location.class).tr("Location"), object);
    }

    public String getId() {
        return "location";
    }

    public boolean isVisible() {
        return this.object instanceof DataCollectionTarget && !(this.object instanceof Circuit) || this.object instanceof Collector || this.object instanceof Container || this.object instanceof Rack || this.object instanceof Zone;
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GeoLocation gl = this.object.getGeolocation();
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        Group typeGroup = new Group(dialogArea, 0);
        typeGroup.setText(this.i18n.tr("Location type"));
        GridData gd = new GridData();
        gd.verticalSpan = 2;
        typeGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        typeGroup.setLayout((Layout)layout);
        this.radioTypeUndefined = new Button((Composite)typeGroup, 16);
        this.radioTypeUndefined.setText(this.i18n.tr("&Undefined"));
        this.radioTypeUndefined.setSelection(gl.getType() == 0);
        this.radioTypeManual = new Button((Composite)typeGroup, 16);
        this.radioTypeManual.setText(this.i18n.tr("&Manual"));
        this.radioTypeManual.setSelection(gl.getType() == 1);
        this.radioTypeAuto = new Button((Composite)typeGroup, 16);
        this.radioTypeAuto.setText(this.i18n.tr("&Automatic from GPS receiver"));
        this.radioTypeAuto.setSelection(gl.getType() == 2);
        this.latitude = new LabeledText(dialogArea, 0);
        this.latitude.setLabel(this.i18n.tr("Latitude"));
        if (gl.getType() != 0) {
            this.latitude.setText(gl.getLatitudeAsString());
        }
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.latitude.setLayoutData((Object)gd);
        this.latitude.setEnabled(gl.getType() == 1);
        this.longitude = new LabeledText(dialogArea, 0);
        this.longitude.setLabel(this.i18n.tr("Longitude"));
        if (gl.getType() != 0) {
            this.longitude.setText(gl.getLongitudeAsString());
        }
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.longitude.setLayoutData((Object)gd);
        this.longitude.setEnabled(gl.getType() == 1);
        1 listener = new /* Unavailable Anonymous Inner Class!! */;
        this.radioTypeUndefined.addSelectionListener((SelectionListener)listener);
        this.radioTypeManual.addSelectionListener((SelectionListener)listener);
        this.radioTypeAuto.addSelectionListener((SelectionListener)listener);
        this.country = new LabeledText(dialogArea, 0);
        this.country.setLabel(this.i18n.tr("Country"));
        this.country.setText(this.object.getPostalAddress().country);
        this.country.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.region = new LabeledText(dialogArea, 0);
        this.region.setLabel(this.i18n.tr("Region"));
        this.region.setText(this.object.getPostalAddress().region);
        this.region.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.city = new LabeledText(dialogArea, 0);
        this.city.setLabel(this.i18n.tr("City"));
        this.city.setText(this.object.getPostalAddress().city);
        this.city.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.district = new LabeledText(dialogArea, 0);
        this.district.setLabel(this.i18n.tr("District"));
        this.district.setText(this.object.getPostalAddress().district);
        this.district.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.streetAddress = new LabeledText(dialogArea, 0);
        this.streetAddress.setLabel(this.i18n.tr("Street address"));
        this.streetAddress.setText(this.object.getPostalAddress().streetAddress);
        this.streetAddress.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.postcode = new LabeledText(dialogArea, 0);
        this.postcode.setLabel(this.i18n.tr("Postcode"));
        this.postcode.setText(this.object.getPostalAddress().postcode);
        this.postcode.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        GeoLocation location;
        int type = 0;
        if (this.radioTypeManual.getSelection()) {
            type = 1;
        } else if (this.radioTypeAuto.getSelection()) {
            type = 2;
        }
        if (type == 1) {
            try {
                location = GeoLocation.parseGeoLocation((String)this.latitude.getText(), (String)this.longitude.getText());
            }
            catch (GeoLocationFormatException e) {
                MessageDialogHelper.openError((Shell)this.getShell(), (String)this.i18n.tr("Error"), (String)this.i18n.tr("Geolocation format error"));
                return false;
            }
        } else {
            location = new GeoLocation(type == 2);
        }
        NXCObjectModificationData md = new NXCObjectModificationData(this.object.getObjectId());
        md.setGeolocation(location);
        md.setPostalAddress(new PostalAddress(this.country.getText().trim(), this.region.getText().trim(), this.city.getText().trim(), this.district.getText().trim(), this.streetAddress.getText().trim(), this.postcode.getText().trim()));
        if (isApply) {
            this.setValid(false);
        }
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.radioTypeUndefined.setSelection(true);
        this.radioTypeManual.setSelection(false);
        this.radioTypeAuto.setSelection(false);
        this.latitude.setText("");
        this.latitude.setEnabled(false);
        this.longitude.setText("");
        this.longitude.setEnabled(false);
    }
}

