/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.propertypages;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.LabeledSpinner;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.propertypages.ObjectPropertyPage;
import org.netxms.nxmc.modules.objects.widgets.ObjectSelector;
import org.xnap.commons.i18n.I18n;

public class Modbus
extends ObjectPropertyPage {
    private I18n i18n = LocalizationHelper.getI18n(Modbus.class);
    private AbstractNode node;
    private LabeledSpinner tcpPort;
    private LabeledSpinner unitId;
    private ObjectSelector proxy;

    public Modbus(AbstractObject object) {
        super(LocalizationHelper.getI18n(Modbus.class).tr("Modbus"), object);
    }

    public String getId() {
        return "communication.modbus";
    }

    public String getParentId() {
        return "communication";
    }

    public boolean isVisible() {
        return this.object instanceof AbstractNode;
    }

    protected Control createContents(Composite parent) {
        this.node = (AbstractNode)this.object;
        Composite dialogArea = new Composite(parent, 0);
        GridLayout dialogLayout = new GridLayout();
        dialogLayout.marginWidth = 0;
        dialogLayout.marginHeight = 0;
        dialogLayout.horizontalSpacing = 5;
        dialogLayout.numColumns = 2;
        dialogLayout.makeColumnsEqualWidth = true;
        dialogArea.setLayout((Layout)dialogLayout);
        this.tcpPort = new LabeledSpinner(dialogArea, 0);
        this.tcpPort.setLabel(this.i18n.tr("TCP port"));
        this.tcpPort.setRange(1, 65535);
        this.tcpPort.setSelection(this.node.getModbusTcpPort());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        this.tcpPort.setLayoutData((Object)gd);
        this.unitId = new LabeledSpinner(dialogArea, 0);
        this.unitId.setLabel(this.i18n.tr("Unit ID"));
        this.unitId.setRange(0, 255);
        this.unitId.setSelection(this.node.getModbusUnitId());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        this.unitId.setLayoutData((Object)gd);
        this.proxy = new ObjectSelector(dialogArea, 0, true);
        this.proxy.setLabel(this.i18n.tr("Proxy"));
        this.proxy.setObjectId(this.node.getModbusProxyId());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.proxy.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        if (isApply) {
            this.setValid(false);
        }
        NXCObjectModificationData md = new NXCObjectModificationData(this.node.getObjectId());
        md.setModbusTcpPort(Integer.valueOf(this.tcpPort.getSelection()));
        md.setModbusUnitId(Short.valueOf((short)this.unitId.getSelection()));
        md.setModbusProxy(Long.valueOf(this.proxy.getObjectId()));
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.tcpPort.setText("502");
        this.unitId.setText("1");
        this.proxy.setObjectId(0L);
    }
}

