/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.propertypages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.client.users.ResponsibleUser;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.propertypages.ObjectPropertyPage;
import org.netxms.nxmc.modules.objects.propertypages.ResponsibleUsers;
import org.xnap.commons.i18n.I18n;

public class ResponsibleUsers
extends ObjectPropertyPage {
    private I18n i18n = LocalizationHelper.getI18n(ResponsibleUsers.class);
    private TableViewer viewer;
    private Map<Integer, ResponsibleUserInfo> users = new HashMap();
    private NXCSession session = Registry.getSession();

    public ResponsibleUsers(AbstractObject object) {
        super(LocalizationHelper.getI18n(ResponsibleUsers.class).tr("Responsible Users"), object);
    }

    public String getId() {
        return "responsibleUsers";
    }

    protected Control createContents(Composite parent) {
        for (ResponsibleUser r : this.object.getResponsibleUsers()) {
            this.users.put(r.userId, new ResponsibleUserInfo(this, r));
        }
        Composite dialogArea = new Composite(parent, 0);
        dialogArea.setLayout((Layout)new GridLayout());
        this.viewer = new TableViewer(dialogArea, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ResponsibleUsersLabelProvider());
        this.viewer.setComparator((ViewerComparator)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.getTable().setHeaderVisible(true);
        TableColumn column = new TableColumn(this.viewer.getTable(), 0);
        column.setText(this.i18n.tr("User"));
        column.setWidth(300);
        column = new TableColumn(this.viewer.getTable(), 0);
        column.setText(this.i18n.tr("Tag"));
        column.setWidth(120);
        ArrayList<String> tags = new ArrayList<String>(this.session.getResponsibleUserTags());
        tags.add("");
        tags.sort((s1, s2) -> s1.compareToIgnoreCase((String)s2));
        this.viewer.setColumnProperties(new String[]{"name", "tag"});
        this.viewer.setCellEditors(new CellEditor[]{null, new ComboBoxCellEditor((Composite)this.viewer.getTable(), tags.toArray(new String[tags.size()]), 12)});
        this.viewer.setCellModifier((ICellModifier)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.setInput((Object)this.users.values().toArray());
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        this.viewer.getControl().setLayoutData((Object)gd);
        Composite buttons = new Composite(dialogArea, 0);
        FillLayout buttonsLayout = new FillLayout();
        buttonsLayout.spacing = 2;
        buttons.setLayout((Layout)buttonsLayout);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        gd.widthHint = 184;
        buttons.setLayoutData((Object)gd);
        Button addButton = new Button(buttons, 8);
        addButton.setText(this.i18n.tr("&Add..."));
        addButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Button deleteButton = new Button(buttons, 8);
        deleteButton.setText(this.i18n.tr("&Delete"));
        deleteButton.setEnabled(false);
        deleteButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.syncUsersAndRefresh();
        return dialogArea;
    }

    void syncUsersAndRefresh() {
        if (this.session.isUserDatabaseSynchronized()) {
            return;
        }
        6 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    protected boolean applyChanges(boolean isApply) {
        if (isApply) {
            this.setValid(false);
        }
        ArrayList<ResponsibleUser> list = new ArrayList<ResponsibleUser>(this.users.size());
        for (ResponsibleUserInfo ri : this.users.values()) {
            list.add(new ResponsibleUser(ri.userId, ri.tag));
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.users.clear();
        this.viewer.setInput((Object)new AbstractUserObject[0]);
    }
}

