/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views;

import java.util.Date;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.TextOutputListener;
import org.netxms.client.constants.ObjectPollType;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.interfaces.PollingTarget;
import org.netxms.nxmc.Memento;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.views.ViewNotRestoredException;
import org.netxms.nxmc.base.widgets.StyledText;
import org.netxms.nxmc.base.widgets.helpers.StyleRange;
import org.netxms.nxmc.localization.DateFormatFactory;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.AdHocObjectView;
import org.netxms.nxmc.resources.ResourceManager;
import org.xnap.commons.i18n.I18n;

/*
 * Exception performing whole class analysis ignored.
 */
public class ObjectPollerView
extends AdHocObjectView
implements TextOutputListener {
    private static final Color COLOR_ERROR = new Color((Device)Display.getCurrent(), 192, 0, 0);
    private static final Color COLOR_WARNING = new Color((Device)Display.getCurrent(), 255, 128, 0);
    private static final Color COLOR_INFO = new Color((Device)Display.getCurrent(), 0, 128, 0);
    private static final Color COLOR_LOCAL = new Color((Device)Display.getCurrent(), 0, 0, 192);
    private final I18n i18n = LocalizationHelper.getI18n(ObjectPollerView.class);
    private PollingTarget target;
    private ObjectPollType pollType;
    private StyledText textArea;
    private Action actionRestart;
    private Action actionClearOutput;
    private boolean startPollOnOpen = false;

    private static String getViewName(ObjectPollType type) {
        String[] names = new String[]{"", LocalizationHelper.getI18n(ObjectPollerView.class).tr("Status Poll"), LocalizationHelper.getI18n(ObjectPollerView.class).tr("Configuration Poll (Full)"), LocalizationHelper.getI18n(ObjectPollerView.class).tr("Interface Poll"), LocalizationHelper.getI18n(ObjectPollerView.class).tr("Topology Poll"), LocalizationHelper.getI18n(ObjectPollerView.class).tr("Configuration Poll"), LocalizationHelper.getI18n(ObjectPollerView.class).tr("Instance Discovery Poll"), LocalizationHelper.getI18n(ObjectPollerView.class).tr("Routing Table Poll"), LocalizationHelper.getI18n(ObjectPollerView.class).tr("Network Discovery Poll"), LocalizationHelper.getI18n(ObjectPollerView.class).tr("Automatic Binding Poll"), LocalizationHelper.getI18n(ObjectPollerView.class).tr("Map Update Poll")};
        return names[type.getValue()];
    }

    public ObjectPollerView(AbstractObject object, ObjectPollType pollType, long contextId, boolean startPollOnOpen) {
        super(ObjectPollerView.getViewName((ObjectPollType)pollType), ResourceManager.getImageDescriptor((String)"icons/object-views/poller_view.png"), "objects.poll." + pollType.toString().toLowerCase(), object.getObjectId(), contextId, false);
        this.target = (PollingTarget)object;
        this.pollType = pollType;
        this.startPollOnOpen = startPollOnOpen;
    }

    protected ObjectPollerView() {
        super(null, ResourceManager.getImageDescriptor((String)"icons/object-views/poller_view.png"), null, 0L, 0L, false);
    }

    public View cloneView() {
        ObjectPollerView view = (ObjectPollerView)super.cloneView();
        view.target = this.target;
        view.pollType = this.pollType;
        return view;
    }

    protected void postClone(View origin) {
        super.postClone(origin);
        this.textArea.replaceContent(((ObjectPollerView)origin).textArea);
        Registry.getPollManager().followPoll(this.target, this.pollType, (TextOutputListener)this);
    }

    protected void createContent(Composite parent) {
        this.textArea = new StyledText(parent, 770);
        this.textArea.setEditable(false);
        this.textArea.setScrollOnAppend(true);
        this.textArea.setFont(JFaceResources.getTextFont());
        this.createActions();
    }

    protected void postContentCreate() {
        super.postContentCreate();
        if (this.startPollOnOpen) {
            this.startPoll();
            this.startPollOnOpen = false;
        }
    }

    private void createActions() {
        this.actionRestart = new /* Unavailable Anonymous Inner Class!! */;
        this.actionClearOutput = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+L", (IAction)this.actionClearOutput);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        super.fillLocalToolBar(manager);
        manager.add((IAction)this.actionRestart);
        manager.add((IAction)this.actionClearOutput);
    }

    private void addPollerMessage(String message) {
        Date now = new Date();
        this.textArea.append("[" + DateFormatFactory.getDateTimeFormat().format(now) + "] ");
        int index = message.indexOf(127);
        if (index != -1) {
            this.textArea.append(message.substring(0, index));
            char code = message.charAt(index + 1);
            int lastPos = this.textArea.getCharCount();
            String msgPart = message.substring(index + 2);
            this.textArea.append(msgPart);
            StyleRange style = new StyleRange();
            style.start = lastPos;
            style.length = msgPart.length();
            style.foreground = this.getTextColor(code);
            this.textArea.setStyleRange(style);
        } else {
            this.textArea.append(message);
        }
    }

    private Color getTextColor(char code) {
        switch (code) {
            case 'e': {
                return COLOR_ERROR;
            }
            case 'w': {
                return COLOR_WARNING;
            }
            case 'i': {
                return COLOR_INFO;
            }
            case 'l': {
                return COLOR_LOCAL;
            }
        }
        return null;
    }

    public void startPoll() {
        this.actionRestart.setEnabled(false);
        Registry.getPollManager().startNewPoll(this.target, this.pollType, (TextOutputListener)this);
    }

    public void messageReceived(String text) {
        this.getDisplay().asyncExec(() -> {
            if (!this.textArea.isDisposed()) {
                this.addPollerMessage(text);
            }
        });
    }

    public void setStreamId(long streamId) {
    }

    public void onFailure(Exception exception) {
        this.getDisplay().asyncExec(() -> {
            if (!this.textArea.isDisposed()) {
                this.actionRestart.setEnabled(true);
            }
        });
    }

    public void onSuccess() {
        this.getDisplay().asyncExec(() -> {
            if (!this.textArea.isDisposed()) {
                this.actionRestart.setEnabled(true);
            }
        });
    }

    public void dispose() {
        Registry.getPollManager().removePollListener(this.target, this.pollType, (TextOutputListener)this);
        super.dispose();
    }

    public void saveState(Memento memento) {
        super.saveState(memento);
        memento.set("pollType", this.pollType.toString());
    }

    public void restoreState(Memento memento) throws ViewNotRestoredException {
        super.restoreState(memento);
        this.pollType = ObjectPollType.valueOf((String)memento.getAsString("pollType"));
        this.setName(ObjectPollerView.getViewName((ObjectPollType)this.pollType));
        long objectId = memento.getAsLong("objectId", 0L);
        this.target = (PollingTarget)this.session.findObjectById(objectId, PollingTarget.class);
        if (this.target == null) {
            throw new ViewNotRestoredException(this.i18n.tr("Object no longer exists or is not accessible"));
        }
    }
}

