/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.SoftwarePackage;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Collector;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.Node;
import org.netxms.nxmc.base.actions.ExportToCsvAction;
import org.netxms.nxmc.base.actions.ViewerProvider;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.base.widgets.SortableTreeViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objects.views.helpers.SoftwareInventoryContentProvider;
import org.netxms.nxmc.modules.objects.views.helpers.SoftwareInventoryNode;
import org.netxms.nxmc.modules.objects.views.helpers.SoftwarePackageComparator;
import org.netxms.nxmc.modules.objects.views.helpers.SoftwarePackageFilter;
import org.netxms.nxmc.modules.objects.views.helpers.SoftwarePackageLabelProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class SoftwareInventoryView
extends ObjectView {
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_VERSION = 1;
    public static final int COLUMN_VENDOR = 2;
    public static final int COLUMN_DATE = 3;
    public static final int COLUMN_DESCRIPTION = 4;
    public static final int COLUMN_URL = 5;
    private final I18n i18n = LocalizationHelper.getI18n(SoftwareInventoryView.class);
    private final String[] names = new String[]{this.i18n.tr("Name"), this.i18n.tr("Version"), this.i18n.tr("Vendor"), this.i18n.tr("Install Date"), this.i18n.tr("Description"), this.i18n.tr("URL")};
    private final int[] widths = new int[]{200, 100, 200, 100, 300, 200};
    private ColumnViewer viewer;
    private SoftwarePackageFilter filter = new SoftwarePackageFilter();
    private MenuManager menuManager = null;
    private Action actionExportToCsv;
    private Action actionExportAllToCsv;
    private Action actionUninstall;

    public SoftwareInventoryView() {
        super(LocalizationHelper.getI18n(SoftwareInventoryView.class).tr("Software Inventory"), ResourceManager.getImageDescriptor((String)"icons/object-views/software.png"), "objects.software-inventory", true);
    }

    protected void postClone(View view) {
        super.postClone(view);
        this.refresh();
    }

    public boolean isValidForContext(Object context) {
        if (context != null && context instanceof Node) {
            return (((Node)context).getCapabilities() & 2L) != 0L;
        }
        return context != null && (context instanceof Container || context instanceof Collector);
    }

    public int getPriority() {
        return 60;
    }

    protected void createContent(Composite parent) {
        this.createTableViewer();
        this.createActions();
        this.createContextMenu();
    }

    private void createActions() {
        ViewerProvider vp = () -> this.viewer;
        this.actionExportToCsv = new ExportToCsvAction((View)this, vp, true);
        this.actionExportAllToCsv = new ExportToCsvAction((View)this, vp, false);
        this.actionUninstall = new /* Unavailable Anonymous Inner Class!! */;
    }

    protected void fillContextMenu(IMenuManager manager) {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        manager.add((IAction)this.actionExportToCsv);
        manager.add((IContributionItem)new Separator());
        if (selection.size() == 1 && selection.getFirstElement() instanceof SoftwarePackage && !((SoftwarePackage)selection.getFirstElement()).getUninstallKey().isEmpty()) {
            manager.add((IAction)this.actionUninstall);
        }
    }

    private void createContextMenu() {
        this.menuManager = new MenuManager();
        this.menuManager.setRemoveAllWhenShown(true);
        this.menuManager.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        if (this.viewer != null) {
            Menu menu = this.menuManager.createContextMenu(this.viewer.getControl());
            this.viewer.getControl().setMenu(menu);
        }
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionExportAllToCsv);
        manager.add((IContributionItem)new Separator());
    }

    public void refresh() {
        AbstractObject object = this.getObject();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    protected void onObjectChange(AbstractObject object) {
        this.viewer.setInput(new ArrayList());
        if (object == null) {
            return;
        }
        this.setRootObjectId(object.getObjectId());
        this.refresh();
    }

    private void createTableViewer() {
        this.viewer = new SortableTableViewer(this.getClientArea(), this.names, this.widths, 0, 128, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new SoftwarePackageLabelProvider(false));
        this.viewer.setComparator((ViewerComparator)new SoftwarePackageComparator());
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.setFilterClient((ISelectionProvider)this.viewer, (AbstractViewerFilter)this.filter);
        if (this.menuManager != null) {
            Menu menu = this.menuManager.createContextMenu(this.viewer.getControl());
            this.viewer.getControl().setMenu(menu);
        }
    }

    private void createTreeViewer() {
        this.viewer = new SortableTreeViewer(this.getClientArea(), this.names, this.widths, 0, 128, 65538);
        this.viewer.setContentProvider((IContentProvider)new SoftwareInventoryContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new SoftwarePackageLabelProvider(true));
        this.viewer.setComparator((ViewerComparator)new SoftwarePackageComparator());
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.setFilterClient((ISelectionProvider)this.viewer, (AbstractViewerFilter)this.filter);
        if (this.menuManager != null) {
            Menu menu = this.menuManager.createContextMenu(this.viewer.getControl());
            this.viewer.getControl().setMenu(menu);
        }
    }

    public void setRootObjectId(long rootObjectId) {
        AbstractObject object = this.session.findObjectById(rootObjectId);
        if (object instanceof Node) {
            if (!(this.viewer instanceof SortableTableViewer)) {
                this.viewer.getControl().dispose();
                this.createTableViewer();
                this.getClientArea().layout(true, true);
            }
        } else if (!(this.viewer instanceof SortableTreeViewer)) {
            this.viewer.getControl().dispose();
            this.createTreeViewer();
            this.getClientArea().layout(true, true);
        }
    }

    private void uninstallPackage() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        SoftwarePackage pkg = (SoftwarePackage)selection.getFirstElement();
        if (pkg.getUninstallKey().isEmpty()) {
            return;
        }
        if (!MessageDialogHelper.openConfirm((Shell)this.getWindow().getShell(), (String)this.i18n.tr("Confirm Uninstall"), (String)this.i18n.tr("You are about to request uninstall of software package \"{0}\".\nUninstallation may fail if selected package does not support unattended installation.\nDo you want to continue?", (Object)pkg.getName()))) {
            return;
        }
        long nodeId = pkg.getData() != null ? ((SoftwareInventoryNode)pkg.getData()).getNode().getObjectId() : this.getObjectId();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }
}

