/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.netxms.client.UserSession;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Node;
import org.netxms.nxmc.base.actions.ExportToCsvAction;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objects.views.ScreenshotView;
import org.netxms.nxmc.modules.objects.views.UserSessionsView;
import org.netxms.nxmc.modules.objects.views.helpers.UserSessionComparator;
import org.netxms.nxmc.modules.objects.views.helpers.UserSessionFilter;
import org.netxms.nxmc.modules.objects.views.helpers.UserSessionLabelProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.ViewRefreshController;
import org.netxms.nxmc.tools.VisibilityValidator;
import org.xnap.commons.i18n.I18n;

public class UserSessionsView
extends ObjectView {
    private final I18n i18n = LocalizationHelper.getI18n(UserSessionsView.class);
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_USER = 1;
    public static final int COLUMN_TERMINAL = 2;
    public static final int COLUMN_STATE = 3;
    public static final int COLUMN_CLIENT_NAME = 4;
    public static final int COLUMN_CLIENT_ADDRESS = 5;
    public static final int COLUMN_DISPLAY = 6;
    public static final int COLUMN_LOGIN_TIME = 7;
    public static final int COLUMN_IDLE_TIME = 8;
    public static final int COLUMN_AGENT_TYPE = 9;
    public static final int COLUMN_AGENT_PID = 10;
    private SortableTableViewer viewer;
    private ViewRefreshController refreshController;
    private Action actionExportToCsv;
    private Action actionExportAllToCsv;
    private Action actionTakeScreenshot;

    public UserSessionsView() {
        super(LocalizationHelper.getI18n(UserSessionsView.class).tr("User Sessions"), ResourceManager.getImageDescriptor((String)"icons/object-views/user-sessions.png"), "objects.user-sessions", true);
    }

    public boolean isValidForContext(Object context) {
        return context != null && context instanceof Node && ((Node)context).hasAgent();
    }

    public int getPriority() {
        return 75;
    }

    protected void createContent(Composite parent) {
        String[] names = new String[]{this.i18n.tr("ID"), this.i18n.tr("User"), this.i18n.tr("Terminal"), this.i18n.tr("State"), this.i18n.tr("Client name"), this.i18n.tr("Client address"), this.i18n.tr("Display"), this.i18n.tr("Login timestamp"), this.i18n.tr("Idle time"), this.i18n.tr("Agent type"), this.i18n.tr("Agent PID")};
        int[] widths = new int[]{100, 150, 150, 100, 150, 150, 150, 180, 120, 150, 120};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 128, 65538);
        this.viewer.setLabelProvider((IBaseLabelProvider)new UserSessionLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator((ViewerComparator)new UserSessionComparator());
        UserSessionFilter filter = new UserSessionFilter();
        this.viewer.addFilter((ViewerFilter)filter);
        this.setFilterClient((ISelectionProvider)this.viewer, (AbstractViewerFilter)filter);
        1 validator = new /* Unavailable Anonymous Inner Class!! */;
        this.refreshController = new ViewRefreshController((View)this, -1, (Runnable)new /* Unavailable Anonymous Inner Class!! */, (VisibilityValidator)validator);
        this.refreshController.setInterval(30);
        this.createActions();
        this.createContextMenu();
    }

    protected void postContentCreate() {
        super.postContentCreate();
    }

    protected void onObjectChange(AbstractObject object) {
        this.refresh();
    }

    public void dispose() {
        this.refreshController.dispose();
        super.dispose();
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu((Control)this.viewer.getTable());
        this.viewer.getTable().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() >= 1) {
            manager.add((IAction)this.actionExportToCsv);
            manager.add((IAction)this.actionExportAllToCsv);
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.actionTakeScreenshot);
        }
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionExportAllToCsv);
        super.fillLocalToolBar(manager);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionExportAllToCsv);
        super.fillLocalMenu(manager);
    }

    private void createActions() {
        this.actionExportToCsv = new ExportToCsvAction((View)this, (ColumnViewer)this.viewer, true);
        this.actionExportAllToCsv = new ExportToCsvAction((View)this, (ColumnViewer)this.viewer, false);
        this.actionTakeScreenshot = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+T", (IAction)this.actionTakeScreenshot);
    }

    private void takeScreenshot() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() >= 1) {
            for (Object o : selection.toList()) {
                UserSession s = (UserSession)o;
                this.openView((View)new ScreenshotView((AbstractNode)this.getObject(), s.getTerminal(), s.getLoginName(), this.getObjectId()));
            }
        }
    }

    public void refresh() {
        if (!this.isActive()) {
            return;
        }
        long objectId = this.getObjectId();
        if (objectId == 0L) {
            this.viewer.setInput((Object)new Object[0]);
            return;
        }
        5 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }
}

