/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views.elements;

import org.eclipse.swt.widgets.Composite;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.snmp.SnmpVersion;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objects.views.elements.Capabilities;
import org.netxms.nxmc.modules.objects.views.elements.OverviewPageElement;
import org.netxms.nxmc.modules.objects.views.elements.TableElement;
import org.xnap.commons.i18n.I18n;

public class Capabilities
extends TableElement {
    private final I18n i18n = LocalizationHelper.getI18n(Capabilities.class);

    public Capabilities(Composite parent, OverviewPageElement anchor, ObjectView objectView) {
        super(parent, anchor, objectView);
    }

    protected String getTitle() {
        return this.i18n.tr("Capabilities");
    }

    protected void fillTable() {
        if (!(this.getObject() instanceof AbstractNode)) {
            return;
        }
        AbstractNode node = (AbstractNode)this.getObject();
        this.addFlag("802.1x", (node.getCapabilities() & 0x2000L) != 0L);
        this.addFlag(this.i18n.tr("Agent"), (node.getCapabilities() & 2L) != 0L);
        this.addFlag(this.i18n.tr("Bridge"), (node.getCapabilities() & 4L) != 0L);
        this.addFlag("CDP", (node.getCapabilities() & 0x100L) != 0L);
        this.addFlag("EtherNet/IP", (node.getCapabilities() & 0x800000L) != 0L);
        this.addFlag(this.i18n.tr("Entity MIB"), (node.getCapabilities() & 0x8000L) != 0L);
        this.addFlag(this.i18n.tr("Emulated Entity MIB"), (node.getCapabilities() & 0x10000000L) != 0L);
        this.addFlag("LLDP", (node.getCapabilities() & 0x400L) != 0L);
        this.addFlag("Modbus TCP", (node.getCapabilities() & 0x1000000L) != 0L);
        this.addFlag("NDP", (node.getCapabilities() & 0x200L) != 0L);
        this.addFlag("OSPF", (node.getCapabilities() & 0x40L) != 0L);
        this.addFlag(this.i18n.tr("Printer"), (node.getCapabilities() & 0x20L) != 0L);
        this.addFlag(this.i18n.tr("Router"), (node.getCapabilities() & 8L) != 0L);
        this.addFlag("SMCLP", (node.getCapabilities() & 0x100000L) != 0L);
        this.addFlag("SNMP", (node.getCapabilities() & 1L) != 0L);
        if ((node.getCapabilities() & 1L) != 0L) {
            this.addFlag("SNMP ifXTable", (node.getCapabilities() & 0x10000L) != 0L);
            this.addPair(this.i18n.tr("SNMP Port"), Integer.toString(node.getSnmpPort()));
            this.addPair(this.i18n.tr("SNMP Version"), this.getSnmpVersionName(node.getSnmpVersion()));
        }
        this.addFlag("SSH", (node.getCapabilities() & 0x80L) != 0L);
        this.addFlag("STP", (node.getCapabilities() & 0x4000L) != 0L);
        this.addFlag(this.i18n.tr("User Agent"), (node.getCapabilities() & 0x400000L) != 0L);
        this.addFlag("VNC", node.hasVNC());
        this.addFlag("VRRP", (node.getCapabilities() & 0x800L) != 0L);
        this.addFlag(this.i18n.tr("Wireless AP"), (node.getCapabilities() & 0x40000000L) != 0L);
        this.addFlag(this.i18n.tr("Wireless Controller"), (node.getCapabilities() & 0x80000L) != 0L);
    }

    private void addFlag(String name, boolean value) {
        this.addPair(name, value ? this.i18n.tr("Yes") : this.i18n.tr("No"));
    }

    private String getSnmpVersionName(SnmpVersion version) {
        switch (1.$SwitchMap$org$netxms$client$snmp$SnmpVersion[version.ordinal()]) {
            case 1: {
                return "1";
            }
            case 2: {
                return "2c";
            }
            case 3: {
                return "3";
            }
        }
        return "???";
    }

    public boolean isApplicableForObject(AbstractObject object) {
        return object instanceof AbstractNode;
    }
}

