/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views.elements;

import org.eclipse.swt.widgets.Composite;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.AccessPoint;
import org.netxms.client.objects.DataCollectionTarget;
import org.netxms.client.objects.Interface;
import org.netxms.client.objects.MobileDevice;
import org.netxms.client.objects.Sensor;
import org.netxms.client.objects.Template;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objects.views.elements.OverviewPageElement;
import org.netxms.nxmc.modules.objects.views.elements.TableElement;
import org.xnap.commons.i18n.I18n;

public class Inventory
extends TableElement {
    private final I18n i18n = LocalizationHelper.getI18n(Inventory.class);

    public Inventory(Composite parent, OverviewPageElement anchor, ObjectView objectView) {
        super(parent, anchor, objectView);
    }

    public boolean isApplicableForObject(AbstractObject object) {
        return object instanceof DataCollectionTarget || object instanceof Template || object instanceof Interface;
    }

    protected void fillTable() {
        AbstractObject object = this.getObject();
        switch (object.getObjectClass()) {
            case 33: {
                AccessPoint ap = (AccessPoint)object;
                this.addPair(this.i18n.tr("Vendor"), ap.getVendor());
                this.addPair(this.i18n.tr("Model"), ap.getModel());
                this.addPair(this.i18n.tr("Serial number"), ap.getSerialNumber());
                break;
            }
            case 3: {
                Interface parentIface;
                Interface iface = (Interface)object;
                AbstractNode parentNode = iface.getParentNode();
                if (parentNode != null) {
                    this.addPair(this.i18n.tr("Parent node"), parentNode.getObjectName());
                }
                if ((parentIface = iface.getParentInterface()) != null) {
                    this.addPair(this.i18n.tr("Parent interface"), parentIface.getObjectName());
                }
                this.addPair(this.i18n.tr("Circuits"), iface.getAllParents(30).stream().map(AbstractObject::getObjectName).reduce((a, b) -> a + ", " + b).orElse(this.i18n.tr("")), false);
                this.addPair(this.i18n.tr("Interface index"), Integer.toString(iface.getIfIndex()));
                String typeName = iface.getIfTypeName();
                this.addPair(this.i18n.tr("Interface type"), typeName != null ? String.format("%d (%s)", iface.getIfType(), typeName) : Integer.toString(iface.getIfType()));
                this.addPair(this.i18n.tr("Description"), iface.getDescription(), false);
                this.addPair(this.i18n.tr("Interface alias"), iface.getIfAlias(), false);
                if (!iface.isPhysicalPort()) break;
                this.addPair(this.i18n.tr("Physical location"), iface.getPhysicalLocation());
                break;
            }
            case 2: {
                AbstractNode node = (AbstractNode)object;
                this.addPair(this.i18n.tr("Node type"), node.getNodeType().toString(), false);
                this.addPair(this.i18n.tr("Hypervisor type"), node.getHypervisorType(), false);
                this.addPair(this.i18n.tr("Hypervisor information"), node.getHypervisorInformation(), false);
                this.addPair(this.i18n.tr("Vendor"), node.getHardwareVendor(), false);
                if ((node.getCapabilities() & 0x800000L) != 0L) {
                    this.addPair(this.i18n.tr("Device type"), node.getCipDeviceTypeName(), false);
                }
                this.addPair(this.i18n.tr("Product name"), node.getHardwareProductName(), false);
                this.addPair(this.i18n.tr("Product code"), node.getHardwareProductCode(), false);
                this.addPair(this.i18n.tr("Product version"), node.getHardwareProductVersion(), false);
                this.addPair(this.i18n.tr("Serial number"), node.getHardwareSerialNumber(), false);
                if (node.hasAgent()) {
                    this.addPair(this.i18n.tr("Hardware ID"), node.getHardwareIdAsText(), false);
                    this.addPair(this.i18n.tr("Agent version"), node.getAgentVersion());
                    if (node.getAgentId() != null) {
                        this.addPair(this.i18n.tr("Agent ID"), node.getAgentId().toString());
                    }
                }
                this.addPair(this.i18n.tr("System description"), node.getSystemDescription(), false);
                this.addPair(this.i18n.tr("Platform name"), node.getPlatformName(), false);
                this.addPair(this.i18n.tr("SNMP sysName"), node.getSnmpSysName(), false);
                this.addPair(this.i18n.tr("SNMP object ID"), node.getSnmpOID(), false);
                this.addPair(this.i18n.tr("SNMP sysLocation"), node.getSnmpSysLocation(), false);
                this.addPair(this.i18n.tr("SNMP sysContact"), node.getSnmpSysContact(), false);
                if (node.isBridge()) {
                    this.addPair(this.i18n.tr("Bridge base address"), node.getBridgeBaseAddress().toString());
                }
                if (node.isOSPF()) {
                    this.addPair(this.i18n.tr("OSPF router ID"), node.getOSPFRouterId().getHostAddress());
                }
                if (!node.hasSnmpAgent()) break;
                this.addPair(this.i18n.tr("Driver"), node.getDriverName(), false);
                break;
            }
            case 31: {
                MobileDevice md = (MobileDevice)object;
                this.addPair(this.i18n.tr("Device ID"), md.getDeviceId());
                this.addPair(this.i18n.tr("Vendor"), md.getVendor());
                this.addPair(this.i18n.tr("Model"), md.getModel());
                this.addPair(this.i18n.tr("Serial number"), md.getSerialNumber());
                this.addPair(this.i18n.tr("Operating System"), md.getOsName());
                this.addPair(this.i18n.tr("Operating System Version"), md.getOsVersion());
                this.addPair(this.i18n.tr("User"), md.getUserId(), false);
                break;
            }
            case 37: {
                Sensor sensor = (Sensor)object;
                this.addPair(this.i18n.tr("Device class"), sensor.getDeviceClass().getDisplayName(LocalizationHelper.getLocale()));
                this.addPair(this.i18n.tr("Vendor"), sensor.getVendor(), true);
                this.addPair(this.i18n.tr("Model"), sensor.getModel(), true);
                this.addPair(this.i18n.tr("Serial number"), sensor.getSerialNumber(), true);
                break;
            }
            case 8: {
                Template template = (Template)object;
                this.addPair(this.i18n.tr("Number of DCIs"), Integer.toString(template.getNumDataCollectionItems()));
                this.addPair(this.i18n.tr("Number of policies"), Integer.toString(template.getNumPolicies()));
                break;
            }
        }
        if (object instanceof DataCollectionTarget) {
            this.addPair(this.i18n.tr("Number of DCIs"), Integer.toString(((DataCollectionTarget)object).getNumDataCollectionItems()));
        }
    }

    protected String getTitle() {
        return this.i18n.tr("Inventory");
    }
}

