/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views.elements;

import org.eclipse.swt.widgets.Composite;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.MobileDevice;
import org.netxms.client.objects.Rack;
import org.netxms.client.objects.interfaces.HardwareEntity;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objects.views.elements.OverviewPageElement;
import org.netxms.nxmc.modules.objects.views.elements.TableElement;
import org.xnap.commons.i18n.I18n;

public class Location
extends TableElement {
    private final I18n i18n = LocalizationHelper.getI18n(Location.class);

    public Location(Composite parent, OverviewPageElement anchor, ObjectView objectView) {
        super(parent, anchor, objectView);
    }

    public boolean isApplicableForObject(AbstractObject object) {
        return object.getGeolocation().getType() != 0 || !object.getPostalAddress().isEmpty() || object instanceof HardwareEntity && ((HardwareEntity)object).getPhysicalContainerId() != 0L;
    }

    protected void fillTable() {
        AbstractObject object = this.getObject();
        if (object.getGeolocation().getType() != 0) {
            this.addPair(this.i18n.tr("Coordinates"), object.getGeolocation().toString());
            this.addPair(this.i18n.tr("Source"), this.getLocationSource(object.getGeolocation().getType()));
            if (object.getGeolocation().getType() != 1) {
                this.addPair(this.i18n.tr("Accuracy"), object.getGeolocation().getAccuracy() + " m");
            }
            if (object instanceof MobileDevice) {
                MobileDevice md = (MobileDevice)object;
                if (md.getSpeed() >= 0.0f) {
                    this.addPair(this.i18n.tr("Speed"), Double.toString(md.getSpeed()) + " km/h");
                }
                if (md.getDirection() >= 0) {
                    this.addPair(this.i18n.tr("Direction"), Integer.toString(md.getDirection()) + "\u00b0");
                }
                this.addPair(this.i18n.tr("Altitude"), Integer.toString(md.getAltitude()) + " m");
            }
        }
        if (!object.getPostalAddress().isEmpty()) {
            this.addPair(this.i18n.tr("Postal Address"), object.getPostalAddress().getAddressLine());
        }
        if (object instanceof HardwareEntity && ((HardwareEntity)object).getPhysicalContainerId() != 0L) {
            HardwareEntity he = (HardwareEntity)object;
            Rack rack = (Rack)Registry.getSession().findObjectById(he.getPhysicalContainerId(), Rack.class);
            if (rack != null) {
                this.addPair(this.i18n.tr("Rack"), String.format(this.i18n.tr("%s (units %d-%d)"), rack.getObjectName(), rack.isTopBottomNumbering() ? he.getRackPosition() : he.getRackPosition() - he.getRackHeight() + 1, rack.isTopBottomNumbering() ? he.getRackPosition() + he.getRackHeight() - 1 : he.getRackPosition()));
            }
        }
    }

    protected String getTitle() {
        return this.i18n.tr("Location");
    }

    private String getLocationSource(int source) {
        switch (source) {
            case 2: {
                return "GPS";
            }
            case 1: {
                return this.i18n.tr("Manual");
            }
            case 3: {
                return this.i18n.tr("Network");
            }
        }
        return this.i18n.tr("Other");
    }
}

