/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views.elements;

import org.eclipse.swt.widgets.Composite;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.NetworkPathFailureReason;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.constants.SpanningTreePortState;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.AccessPoint;
import org.netxms.client.objects.Asset;
import org.netxms.client.objects.BusinessService;
import org.netxms.client.objects.Interface;
import org.netxms.client.objects.MobileDevice;
import org.netxms.client.topology.NetworkPathCheckResult;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.DateFormatFactory;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objects.views.elements.ObjectState;
import org.netxms.nxmc.modules.objects.views.elements.OverviewPageElement;
import org.netxms.nxmc.modules.objects.views.elements.TableElement;
import org.netxms.nxmc.modules.objects.views.helpers.InterfaceListLabelProvider;
import org.netxms.nxmc.resources.StatusDisplayInfo;
import org.xnap.commons.i18n.I18n;

/*
 * Exception performing whole class analysis ignored.
 */
public class ObjectState
extends TableElement {
    private final I18n i18n = LocalizationHelper.getI18n(ObjectState.class);
    private final String[] ifaceExpectedState = new String[]{this.i18n.tr("Up"), this.i18n.tr("Down"), this.i18n.tr("Ignore"), this.i18n.tr("Auto")};
    private final NXCSession session = Registry.getSession();

    public ObjectState(Composite parent, OverviewPageElement anchor, ObjectView objectView) {
        super(parent, anchor, objectView);
    }

    protected void fillTable() {
        AbstractObject object = this.getObject();
        if (object.isInMaintenanceMode()) {
            this.addPair(this.i18n.tr("Status"), StatusDisplayInfo.getStatusText((ObjectStatus)object.getStatus()) + this.i18n.tr(" (maintenance)"));
            AbstractUserObject user = this.session.findUserDBObjectById(object.getMaintenanceInitiatorId(), (Runnable)new /* Unavailable Anonymous Inner Class!! */);
            this.addPair(this.i18n.tr("Maintenance initiator"), (String)(user != null ? user.getName() : "[" + object.getMaintenanceInitiatorId() + "]"));
        } else {
            this.addPair(this.i18n.tr("Status"), StatusDisplayInfo.getStatusText((ObjectStatus)object.getStatus()));
        }
        switch (object.getObjectClass()) {
            case 33: {
                AccessPoint ap = (AccessPoint)object;
                this.addPair(this.i18n.tr("State"), ap.getState().toString());
                break;
            }
            case 16: {
                Asset asset = (Asset)object;
                if (asset.getLastUpdateTimestamp() == null || asset.getLastUpdateTimestamp().getTime() == 0L) break;
                this.addPair(this.i18n.tr("Last updated"), DateFormatFactory.getDateTimeFormat().format(asset.getLastUpdateTimestamp()));
                AbstractUserObject user = this.session.findUserDBObjectById(asset.getLastUpdateUserId(), () -> this.getDisplay().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */));
                this.addPair(this.i18n.tr("Updated by"), (String)(user != null ? user.getName() : "[" + asset.getLastUpdateUserId() + "]"));
                break;
            }
            case 28: {
                BusinessService businessService = (BusinessService)object;
                this.addPair(this.i18n.tr("Service state"), businessService.getServiceState().toString());
                break;
            }
            case 3: {
                AbstractNode node;
                Interface iface = (Interface)object;
                this.addPair(this.i18n.tr("Administrative state"), iface.getAdminStateAsText());
                this.addPair(this.i18n.tr("Operational state"), iface.getOperStateAsText());
                this.addPair(this.i18n.tr("Expected state"), this.ifaceExpectedState[iface.getExpectedState()]);
                if (iface.isPhysicalPort() && (node = iface.getParentNode()) != null) {
                    if (node.isBridge() && iface.getStpPortState() != SpanningTreePortState.UNKNOWN) {
                        this.addPair(this.i18n.tr("Spanning Tree port state"), iface.getStpPortState().getText());
                    }
                    if (node.is8021xSupported()) {
                        this.addPair(this.i18n.tr("802.1x PAE state"), iface.getDot1xPaeStateAsText());
                        this.addPair(this.i18n.tr("802.1x backend state"), iface.getDot1xBackendStateAsText());
                    }
                }
                if (iface.isOSPF()) {
                    this.addPair(this.i18n.tr("OSPF interface state"), iface.getOSPFState().getText(), false);
                }
                if (iface.getMtu() > 0) {
                    this.addPair(this.i18n.tr("MTU"), Integer.toString(iface.getMtu()));
                }
                if (iface.getSpeed() > 0L) {
                    this.addPair(this.i18n.tr("Speed"), InterfaceListLabelProvider.ifSpeedTotext((long)iface.getSpeed()));
                }
                if (iface.getInboundUtilization() >= 0) {
                    this.addPair(this.i18n.tr("Inbound utilization"), ObjectState.formatUtilizationValue((int)iface.getInboundUtilization()));
                }
                if (iface.getOutboundUtilization() < 0) break;
                this.addPair(this.i18n.tr("Outbound utilization"), ObjectState.formatUtilizationValue((int)iface.getOutboundUtilization()));
                break;
            }
            case 2: {
                NetworkPathCheckResult pathCheckResult;
                AbstractNode node = (AbstractNode)object;
                if ((node.getCapabilities() & 0x800000L) != 0L) {
                    this.addPair(this.i18n.tr("Device state"), ((AbstractNode)object).getCipStateText(), false);
                    this.addPair(this.i18n.tr("Device status"), ((AbstractNode)object).getCipStatusText(), false);
                    if ((((AbstractNode)object).getCipStatus() >> 4 & 0xF) != 0) {
                        this.addPair(this.i18n.tr("Extended device status"), ((AbstractNode)object).getCipExtendedStatusText(), false);
                    }
                }
                if (node.getBootTime() != null) {
                    this.addPair(this.i18n.tr("Boot time"), DateFormatFactory.getDateTimeFormat().format(node.getBootTime()), false);
                }
                if (node.hasAgent()) {
                    this.addPair(this.i18n.tr("Agent status"), (node.getStateFlags() & 0x10000) != 0 ? this.i18n.tr("Unreachable") : this.i18n.tr("Connected"));
                    if (node.getLastAgentCommTime() != null) {
                        this.addPair(this.i18n.tr("Last agent contact"), DateFormatFactory.getDateTimeFormat().format(node.getLastAgentCommTime()), false);
                    }
                }
                if (node.hasSnmpAgent()) {
                    this.addPair(this.i18n.tr("SNMP status"), (node.getStateFlags() & 0x20000) != 0 ? this.i18n.tr("Unreachable") : this.i18n.tr("Responding"));
                }
                if ((node.getCapabilities() & 0x80L) != 0L) {
                    this.addPair(this.i18n.tr("SSH status"), (node.getStateFlags() & 0x400000) != 0 ? this.i18n.tr("Unreachable") : this.i18n.tr("Responding"));
                }
                if ((node.getStateFlags() & 3) != 3 || (pathCheckResult = node.getNetworkPathCheckResult()).getReason() == NetworkPathFailureReason.NONE) break;
                this.addPair(this.i18n.tr("Network path problem"), this.buildNetworkPathFailureDescription(pathCheckResult), false);
                break;
            }
            case 31: {
                MobileDevice md = (MobileDevice)object;
                if (md.getLastReportTime().getTime() == 0L) {
                    this.addPair(this.i18n.tr("Last report"), this.i18n.tr("Never"));
                } else {
                    this.addPair(this.i18n.tr("Last report"), DateFormatFactory.getDateTimeFormat().format(md.getLastReportTime()));
                }
                if (md.getBatteryLevel() < 0) break;
                this.addPair(this.i18n.tr("Battery level"), Integer.toString(md.getBatteryLevel()) + "%");
                break;
            }
        }
    }

    private static String formatUtilizationValue(int v) {
        return Integer.toString(v / 10) + "." + Integer.toString(v % 10) + "%";
    }

    protected String getTitle() {
        return this.i18n.tr("State");
    }

    private String buildNetworkPathFailureDescription(NetworkPathCheckResult pathCheckResult) {
        if (pathCheckResult.getRootCauseInterfaceId() != 0L && this.session.findObjectById(pathCheckResult.getRootCauseInterfaceId()) == null) {
            new /* Unavailable Anonymous Inner Class!! */.start();
        }
        switch (4.$SwitchMap$org$netxms$client$constants$NetworkPathFailureReason[pathCheckResult.getReason().ordinal()]) {
            case 1: {
                return this.i18n.tr("Interface {0} on node {1} is disabled", (Object)this.session.getObjectName(pathCheckResult.getRootCauseInterfaceId()), (Object)this.session.getObjectName(pathCheckResult.getRootCauseNodeId()));
            }
            case 2: {
                return this.i18n.tr("Agent on proxy node {0} is unreachable", (Object)this.session.getObjectName(pathCheckResult.getRootCauseNodeId()));
            }
            case 3: {
                return this.i18n.tr("Proxy node {0} is down", (Object)this.session.getObjectName(pathCheckResult.getRootCauseNodeId()));
            }
            case 4: {
                return this.i18n.tr("Intermediate router {0} is down", (Object)this.session.getObjectName(pathCheckResult.getRootCauseNodeId()));
            }
            case 5: {
                return this.i18n.tr("Routing loop detected on intermediate router {0}", (Object)this.session.getObjectName(pathCheckResult.getRootCauseNodeId()));
            }
            case 6: {
                return this.i18n.tr("Intermediate switch {0} is down", (Object)this.session.getObjectName(pathCheckResult.getRootCauseNodeId()));
            }
            case 7: {
                return this.i18n.tr("VPN tunnel {0} on node {1} is down", (Object)this.session.getObjectName(pathCheckResult.getRootCauseInterfaceId()), (Object)this.session.getObjectName(pathCheckResult.getRootCauseNodeId()));
            }
            case 8: {
                return this.i18n.tr("Wireless access point {0} is down", (Object)this.session.getObjectName(pathCheckResult.getRootCauseNodeId()));
            }
        }
        return null;
    }
}

