/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views.helpers;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.NXCSession;
import org.netxms.client.topology.OSPFNeighbor;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.xnap.commons.i18n.I18n;

public class OSPFNeighborLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private I18n i18n = LocalizationHelper.getI18n(OSPFNeighborLabelProvider.class);
    private NXCSession session = Registry.getSession();

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        OSPFNeighbor n = (OSPFNeighbor)element;
        switch (columnIndex) {
            case 6: {
                return n.isVirtual() ? n.getAreaId().getHostAddress() : "";
            }
            case 3: {
                return n.isVirtual() ? "" : Integer.toString(n.getInterfaceIndex());
            }
            case 4: {
                return n.isVirtual() ? "" : this.session.getObjectName(n.getInterfaceId());
            }
            case 1: {
                return n.getIpAddress().getHostAddress();
            }
            case 2: {
                return n.getNodeId() != 0L ? this.session.getObjectName(n.getNodeId()) : "";
            }
            case 0: {
                return n.getRouterId().getHostAddress();
            }
            case 7: {
                return n.getState().getText();
            }
            case 5: {
                return n.isVirtual() ? this.i18n.tr("yes") : this.i18n.tr("no");
            }
        }
        return null;
    }
}

