/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views.helpers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.TextOutputListener;
import org.netxms.client.constants.ObjectPollType;
import org.netxms.client.objects.interfaces.PollingTarget;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.helpers.PollerProxy;
import org.xnap.commons.i18n.I18n;

public class PollerProxy
implements TextOutputListener {
    private final I18n i18n = LocalizationHelper.getI18n(PollerProxy.class);
    private Set<TextOutputListener> listenerSet = new HashSet();
    private List<String> content;
    private boolean pollActive;
    private PollingTarget target;
    private ObjectPollType pollType;

    public PollerProxy(PollingTarget target, ObjectPollType pollType, TextOutputListener listener) {
        this.listenerSet.add(listener);
        this.content = new ArrayList();
        this.pollActive = false;
        this.target = target;
        this.pollType = pollType;
        this.startPoll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(TextOutputListener listener, boolean sendAllPreviousContent) {
        Set set = this.listenerSet;
        synchronized (set) {
            if (sendAllPreviousContent && !this.listenerSet.contains(listener)) {
                for (String s : this.content) {
                    listener.messageReceived(s);
                }
            } else {
                this.listenerSet.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListenerAndCheck(TextOutputListener listener) {
        boolean noMoreListenners = true;
        Set set = this.listenerSet;
        synchronized (set) {
            this.listenerSet.remove(listener);
            noMoreListenners = this.listenerSet.size() == 0;
        }
        return noMoreListenners;
    }

    public void startPoll() {
        if (this.pollActive) {
            return;
        }
        this.pollActive = true;
        this.messageReceived("\u007fl**** Poll request sent to server ****\n");
        NXCSession session = Registry.getSession();
        1 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setSystem(true);
        job.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(String text) {
        Set set = this.listenerSet;
        synchronized (set) {
            this.content.add(text);
            for (TextOutputListener l : this.listenerSet) {
                l.messageReceived(text);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStreamId(long streamId) {
        Set set = this.listenerSet;
        synchronized (set) {
            for (TextOutputListener l : this.listenerSet) {
                l.setStreamId(streamId);
            }
        }
    }

    public void onFailure(Exception exception) {
        this.messageReceived(String.format("\u007fePOLL ERROR: %s\n", exception instanceof NXCException ? exception.getLocalizedMessage() : exception.getClass().getName()));
        this.messageReceived("\u007fl**** Poll failed ****\n\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSuccess() {
        this.messageReceived("\u007fl**** Poll completed successfully ****\n\n");
        Set set = this.listenerSet;
        synchronized (set) {
            for (TextOutputListener l : this.listenerSet) {
                l.onSuccess();
            }
        }
    }
}

