/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views.helpers;

import java.net.InetAddress;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.netxms.client.topology.Route;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.tools.ComparatorHelper;

public class RoutingTableComparator
extends ViewerComparator {
    public int compare(Viewer viewer, Object e1, Object e2) {
        int result;
        Route r1 = (Route)e1;
        Route r2 = (Route)e2;
        switch ((Integer)((SortableTableViewer)viewer).getTable().getSortColumn().getData("ID")) {
            case 0: {
                result = ComparatorHelper.compareInetAddresses((InetAddress)r1.getDestination().getAddress(), (InetAddress)r2.getDestination().getAddress());
                if (result != 0) break;
                result = r1.getDestination().getMask() - r2.getDestination().getMask();
                break;
            }
            case 2: {
                result = r1.getIfName().compareToIgnoreCase(r2.getIfName());
                break;
            }
            case 4: {
                result = Integer.compare(r1.getMetric(), r2.getMetric());
                break;
            }
            case 1: {
                result = ComparatorHelper.compareInetAddresses((InetAddress)r1.getNextHop(), (InetAddress)r2.getNextHop());
                break;
            }
            case 5: {
                result = r1.getProtocol().toString().compareTo(r2.getProtocol().toString());
                break;
            }
            case 3: {
                result = Integer.compare(r1.getType(), r2.getType());
                break;
            }
            default: {
                result = 0;
            }
        }
        return ((SortableTableViewer)viewer).getTable().getSortDirection() == 128 ? result : -result;
    }
}

