/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views.helpers;

import java.util.List;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.netxms.base.InetAddressEx;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.VPNConnector;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.resources.StatusDisplayInfo;

public class VPNConnectorListLabelProvider
extends LabelProvider
implements ITableLabelProvider,
ITableColorProvider {
    private NXCSession session = Registry.getSession();

    public Color getForeground(Object element, int columnIndex) {
        VPNConnector vpn = (VPNConnector)element;
        switch (columnIndex) {
            case 2: {
                StatusDisplayInfo.getStatusColor((ObjectStatus)vpn.getStatus());
            }
        }
        return null;
    }

    public Color getBackground(Object element, int columnIndex) {
        return null;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        VPNConnector vpn = (VPNConnector)element;
        switch (columnIndex) {
            case 0: {
                return Long.toString(vpn.getObjectId());
            }
            case 1: {
                return vpn.getObjectName();
            }
            case 2: {
                return StatusDisplayInfo.getStatusText((ObjectStatus)vpn.getStatus());
            }
            case 3: {
                return this.getPeerName(vpn);
            }
            case 4: {
                return this.getSubnetsAsString(vpn.getLocalSubnets());
            }
            case 5: {
                return this.getSubnetsAsString(vpn.getRemoteSubnets());
            }
        }
        return null;
    }

    public String getPeerName(VPNConnector vpn) {
        AbstractNode peer = (AbstractNode)this.session.findObjectById(vpn.getPeerGatewayId(), AbstractNode.class);
        return peer != null ? peer.getObjectName() : null;
    }

    public String getSubnetsAsString(List<InetAddressEx> subnetList) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < subnetList.size(); ++i) {
            sb.append(subnetList.get(i).toString());
            if (i + 1 == subnetList.size()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }
}

