/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views.helpers;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.netxms.nxmc.modules.objects.views.helpers.VncSocketEndpoint;
import org.netxms.nxmc.modules.objecttools.TcpPortForwarder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@ServerEndpoint(value="/vncviewer/{fwid}")
public class VncSocketEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(VncSocketEndpoint.class);
    private static Map<UUID, TcpPortForwarder> forwarders = Collections.synchronizedMap(new HashMap());
    private static Map<String, VncSession> sessions = Collections.synchronizedMap(new HashMap());

    public static void registerForwarder(TcpPortForwarder forwarder) {
        forwarders.put(forwarder.getId(), forwarder);
    }

    @OnOpen
    public void onOpen(Session session, EndpointConfig config, @PathParam(value="fwid") String forwarderId) {
        logger.debug("VNC websocket session open request (session ID {})", (Object)forwarderId);
        try {
            TcpPortForwarder forwarder = (TcpPortForwarder)forwarders.get(UUID.fromString(forwarderId));
            if (forwarder != null) {
                VncSession vncSession = new VncSession(session, forwarder);
                sessions.put(session.getId(), vncSession);
                logger.debug("Proxy ID {} assigned to VNC websocket session {}", (Object)forwarderId, (Object)session.getId());
            } else {
                logger.debug("Invalid proxy ID {} in VNC websocket session open request", (Object)forwarderId);
                VncSocketEndpoint.closeSession((Session)session, (CloseReason.CloseCode)CloseReason.CloseCodes.CANNOT_ACCEPT, (String)"Invalid proxy ID");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @OnClose
    public void onClose(Session session) {
        logger.debug("VNC websocket session {} closed", (Object)session.getId());
        VncSession vncSession = (VncSession)sessions.remove(session.getId());
        if (vncSession != null) {
            vncSession.close();
        }
    }

    @OnMessage(maxMessageSize=1024000L)
    public void onMessage(Session session, byte[] data) {
        VncSession vncSession = (VncSession)sessions.get(session.getId());
        if (vncSession != null) {
            try {
                vncSession.send(data);
            }
            catch (IOException e) {
                VncSocketEndpoint.closeSession((Session)session, (CloseReason.CloseCode)CloseReason.CloseCodes.PROTOCOL_ERROR, (String)"Socket I/O error");
            }
        } else {
            logger.debug("VNC websocket request with invalid session ID {}", (Object)session.getId());
            VncSocketEndpoint.closeSession((Session)session, (CloseReason.CloseCode)CloseReason.CloseCodes.CANNOT_ACCEPT, (String)"Invalid proxy ID");
        }
    }

    private static void closeSession(Session session, CloseReason.CloseCode code, String message) {
        try {
            session.close(new CloseReason(code, message));
        }
        catch (IOException e) {
            logger.error("Error closing websocket session", (Throwable)e);
        }
    }
}

