/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views.helpers;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.netxms.client.NXCSession;
import org.netxms.client.topology.WirelessStation;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.AbstractViewerFilter;

public class WirelessStationFilter
extends ViewerFilter
implements AbstractViewerFilter {
    private NXCSession session = Registry.getSession();
    private String filterString = null;

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.filterString == null || this.filterString.isEmpty()) {
            return true;
        }
        WirelessStation ws = (WirelessStation)element;
        if (ws.getSsid().toLowerCase().contains(this.filterString)) {
            return true;
        }
        if (ws.getRadioInterface().toLowerCase().contains(this.filterString)) {
            return true;
        }
        if (this.session.getObjectName(ws.getAccessPointId()).toLowerCase().contains(this.filterString)) {
            return true;
        }
        if (ws.getIpAddress() != null && !ws.getIpAddress().isAnyLocalAddress() && ws.getIpAddress().getHostAddress().contains(this.filterString)) {
            return true;
        }
        if (ws.getMacAddress().toString().toLowerCase().contains(this.filterString)) {
            return true;
        }
        String vendor = this.session.getVendorByMac(ws.getMacAddress(), null);
        return vendor != null && vendor.toLowerCase().contains(this.filterString);
    }

    public void setFilterString(String filterString) {
        this.filterString = filterString.toLowerCase();
    }
}

