/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.widgets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Chassis;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.Collector;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.Rack;
import org.netxms.client.objects.ServiceRoot;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objects.widgets.AbstractObjectStatusMap;
import org.netxms.nxmc.modules.objects.widgets.ObjectStatusWidget;

/*
 * Exception performing whole class analysis ignored.
 */
public class FlatObjectStatusMap
extends AbstractObjectStatusMap {
    private List<Composite> sections = new ArrayList();
    private Map<Long, ObjectStatusWidget> statusWidgets = new HashMap();
    private Font titleFont = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.bannerfont");
    private boolean groupObjects = true;
    protected Composite dataArea;

    public FlatObjectStatusMap(ObjectView view, Composite parent, int style) {
        super(view, parent, style);
    }

    protected Composite createContent(Composite parent) {
        this.dataArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 10;
        this.dataArea.setLayout((Layout)layout);
        this.dataArea.setBackground(this.getBackground());
        return this.dataArea;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        for (Composite s : this.sections) {
            s.dispose();
        }
        this.sections.clear();
        Iterator iterator = this.statusWidgets;
        synchronized (iterator) {
            this.statusWidgets.clear();
        }
        if (this.groupObjects) {
            this.buildSection(this.rootObjectId, "");
        } else {
            this.buildFlatView();
        }
        this.dataArea.layout(true, true);
        this.updateScrollBars();
        for (Runnable l : this.refreshListeners) {
            l.run();
        }
    }

    private void buildFlatView() {
        AbstractObject root = this.session.findObjectById(this.rootObjectId);
        if (!(root != null && (root instanceof Collector || root instanceof Container || root instanceof ServiceRoot || root instanceof Cluster || root instanceof Rack || root instanceof Chassis))) {
            return;
        }
        ArrayList objects = new ArrayList(root.getAllChildren(new int[]{2, 14, 31, 33}));
        this.filterObjects(objects);
        Collections.sort(objects, (o1, o2) -> o1.getNameWithAlias().compareToIgnoreCase(o2.getNameWithAlias()));
        Composite clientArea = new Composite(this.dataArea, 0);
        clientArea.setBackground(this.getBackground());
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        clientArea.setLayoutData((Object)gd);
        RowLayout clayout = new RowLayout();
        clayout.marginBottom = 0;
        clayout.marginTop = 0;
        clayout.marginLeft = 0;
        clayout.marginRight = 0;
        clayout.type = 256;
        clayout.wrap = true;
        clayout.pack = false;
        clientArea.setLayout((Layout)clayout);
        this.sections.add(clientArea);
        for (AbstractObject o : objects) {
            if (!FlatObjectStatusMap.isLeafObject((AbstractObject)o)) continue;
            this.addObjectElement(clientArea, o);
        }
    }

    private void buildSection(long rootId, String namePrefix) {
        AbstractObject root = this.session.findObjectById(rootId);
        if (!(root != null && (root instanceof Collector || root instanceof Container || root instanceof ServiceRoot || root instanceof Cluster || root instanceof Rack || root instanceof Chassis))) {
            return;
        }
        ArrayList<AbstractObject> objects = new ArrayList<AbstractObject>(Arrays.asList(root.getChildrenAsArray()));
        Collections.sort(objects, (o1, o2) -> o1.getNameWithAlias().compareToIgnoreCase(o2.getNameWithAlias()));
        Composite section = null;
        Composite clientArea = null;
        for (AbstractObject o : objects) {
            if (!FlatObjectStatusMap.isLeafObject((AbstractObject)o) || !this.isAcceptedByFilter(o)) continue;
            if (section == null) {
                section = new Composite(this.dataArea, 0);
                section.setBackground(this.getBackground());
                GridData gd = new GridData();
                gd.grabExcessHorizontalSpace = true;
                gd.horizontalAlignment = 4;
                section.setLayoutData((Object)gd);
                GridLayout layout = new GridLayout();
                layout.marginHeight = 0;
                layout.marginWidth = 0;
                section.setLayout((Layout)layout);
                Label title = new Label(section, 0);
                title.setBackground(this.getBackground());
                title.setFont(this.titleFont);
                title.setText(namePrefix + root.getNameWithAlias());
                clientArea = new Composite(section, 0);
                clientArea.setBackground(this.getBackground());
                gd = new GridData();
                gd.grabExcessHorizontalSpace = true;
                gd.horizontalAlignment = 4;
                clientArea.setLayoutData((Object)gd);
                RowLayout clayout = new RowLayout();
                clayout.marginBottom = 0;
                clayout.marginTop = 0;
                clayout.marginLeft = 0;
                clayout.marginRight = 0;
                clayout.type = 256;
                clayout.wrap = true;
                clayout.pack = false;
                clientArea.setLayout((Layout)clayout);
                this.sections.add(section);
            }
            this.addObjectElement(clientArea, o);
        }
        for (AbstractObject o : objects) {
            if (!FlatObjectStatusMap.isContainerObject((AbstractObject)o)) continue;
            this.buildSection(o.getObjectId(), namePrefix + root.getNameWithAlias() + " / ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addObjectElement(Composite parent, AbstractObject object) {
        ObjectStatusWidget w = new ObjectStatusWidget(parent, object);
        w.setBackground(this.getBackground());
        w.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = this.menuManager.createContextMenu((Control)w);
        w.setMenu(menu);
        Map map = this.statusWidgets;
        synchronized (map) {
            this.statusWidgets.put(object.getObjectId(), w);
        }
    }

    public boolean isGroupObjects() {
        return this.groupObjects;
    }

    public void setGroupObjects(boolean groupObjects) {
        this.groupObjects = groupObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onObjectChange(AbstractObject object) {
        if (!FlatObjectStatusMap.isContainerObject((AbstractObject)object) && !FlatObjectStatusMap.isLeafObject((AbstractObject)object)) {
            return;
        }
        Map map = this.statusWidgets;
        synchronized (map) {
            ObjectStatusWidget w = (ObjectStatusWidget)this.statusWidgets.get(object.getObjectId());
            if (w != null) {
                this.getDisplay().asyncExec(() -> {
                    if (w.isDisposed()) {
                        return;
                    }
                    if (this.isAcceptedByFilter(object)) {
                        w.updateObject(object);
                    } else {
                        Map map = this.statusWidgets;
                        synchronized (map) {
                            w.dispose();
                            this.statusWidgets.remove(object.getObjectId());
                            this.dataArea.layout(true, true);
                            this.updateScrollBars();
                        }
                    }
                });
            } else if (object.getObjectId() == this.rootObjectId || object.isChildOf(this.rootObjectId) && (FlatObjectStatusMap.isContainerObject((AbstractObject)object) || this.isAcceptedByFilter(object))) {
                this.refreshTimer.execute();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onObjectDelete(long objectId) {
        Map map = this.statusWidgets;
        synchronized (map) {
            ObjectStatusWidget w = (ObjectStatusWidget)this.statusWidgets.get(objectId);
            if (w != null) {
                this.getDisplay().asyncExec(() -> {
                    if (w.isDisposed()) {
                        return;
                    }
                    Map map = this.statusWidgets;
                    synchronized (map) {
                        w.dispose();
                        this.statusWidgets.remove(objectId);
                        this.dataArea.layout(true, true);
                        this.updateScrollBars();
                    }
                });
            }
        }
    }

    protected Point computeSize() {
        Rectangle r = this.getClientArea();
        return this.dataArea.computeSize(r.width, -1);
    }
}

