/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.widgets;

import java.util.List;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.DataCollectionTarget;
import org.netxms.client.objects.Interface;
import org.netxms.client.objects.configs.PassiveRackElement;
import org.netxms.nxmc.modules.objects.widgets.helpers.DecoratingObjectLabelProvider;
import org.netxms.nxmc.resources.StatusDisplayInfo;

/*
 * Exception performing whole class analysis ignored.
 */
public class ObjectPopupDialog
extends PopupDialog {
    private Object object;
    private Point location;
    private CLabel statusLabel = null;
    private Font boldFont = null;
    private DecoratingObjectLabelProvider labelProvider;

    public ObjectPopupDialog(Shell parent, Object object, Point location) {
        super(parent, 540676, true, false, false, false, false, ObjectPopupDialog.getObjectDisplayName((Object)object), null);
        this.object = object;
        this.location = location != null ? location : Display.getCurrent().getCursorLocation();
        this.labelProvider = new DecoratingObjectLabelProvider();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected Point getInitialLocation(Point initialSize) {
        return this.location;
    }

    protected Control createTitleControl(Composite parent) {
        CLabel title = new CLabel(parent, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)title);
        title.setImage(this.labelProvider.getImage(this.object));
        title.setText(ObjectPopupDialog.getObjectDisplayName((Object)this.object));
        FontData fd = title.getFont().getFontData()[0];
        fd.setStyle(1);
        this.boldFont = new Font((Device)title.getDisplay(), fd);
        title.setFont(this.boldFont);
        return title;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        if (this.object instanceof AbstractObject) {
            List values;
            AbstractObject abstractObject = (AbstractObject)this.object;
            this.statusLabel = new CLabel(dialogArea, 0);
            this.statusLabel.setText(StatusDisplayInfo.getStatusText((ObjectStatus)abstractObject.getStatus()).toUpperCase());
            this.statusLabel.setForeground(StatusDisplayInfo.getStatusColor((ObjectStatus)abstractObject.getStatus()));
            this.statusLabel.setFont(this.boldFont);
            StringBuilder sb = new StringBuilder();
            if (this.object instanceof AbstractNode) {
                ObjectPopupDialog.appendText((StringBuilder)sb, (String)((AbstractNode)this.object).getPrimaryIP().getHostAddress());
                ObjectPopupDialog.appendText((StringBuilder)sb, (String)((AbstractNode)this.object).getPlatformName());
                Object sd = ((AbstractNode)this.object).getSystemDescription();
                if (((String)sd).length() > 127) {
                    sd = ((String)sd).substring(0, 127) + "...";
                }
                ObjectPopupDialog.appendText((StringBuilder)sb, (String)sd);
                ObjectPopupDialog.appendText((StringBuilder)sb, (String)((AbstractNode)this.object).getSnmpSysName());
                ObjectPopupDialog.appendText((StringBuilder)sb, (String)((AbstractNode)this.object).getSnmpSysContact());
            } else if (this.object instanceof Interface) {
                ObjectPopupDialog.appendText((StringBuilder)sb, (String)((Interface)this.object).getDescription());
                ObjectPopupDialog.appendText((StringBuilder)sb, (String)((Interface)this.object).getAlias());
                if (!((Interface)this.object).getMacAddress().isNull()) {
                    ObjectPopupDialog.appendText((StringBuilder)sb, (String)((Interface)this.object).getMacAddress().toString());
                }
                ObjectPopupDialog.appendText((StringBuilder)sb, (String)(((Interface)this.object).getAdminStateAsText() + " / " + ((Interface)this.object).getOperStateAsText()));
            }
            if (sb.length() > 0) {
                ObjectPopupDialog.createSeparator((Composite)dialogArea);
                if (sb.charAt(sb.length() - 1) == '\n') {
                    sb.deleteCharAt(sb.length() - 1);
                }
                CLabel infoText = new CLabel(dialogArea, 2);
                infoText.setText(sb.toString());
            }
            if (this.object instanceof DataCollectionTarget && !(values = ((DataCollectionTarget)this.object).getTooltipDciData()).isEmpty()) {
                ObjectPopupDialog.createSeparator((Composite)dialogArea);
                Composite group = new Composite(dialogArea, 0);
                GridLayout layout = new GridLayout();
                layout.marginHeight = 0;
                layout.marginWidth = 0;
                layout.numColumns = 2;
                group.setLayout((Layout)layout);
                StringBuilder leftColumn = new StringBuilder();
                StringBuilder rightColumn = new StringBuilder();
                for (DciValue v : values) {
                    if (leftColumn.length() > 0) {
                        leftColumn.append('\n');
                        rightColumn.append('\n');
                    }
                    leftColumn.append(v.getDescription());
                    rightColumn.append(v.getValue());
                }
                new CLabel(group, 2).setText(leftColumn.toString());
                new CLabel(group, 2).setText(rightColumn.toString());
            }
            if (!abstractObject.getComments().isEmpty()) {
                ObjectPopupDialog.createSeparator((Composite)dialogArea);
                new CLabel(dialogArea, 2).setText(abstractObject.getComments());
            }
        } else if (this.object instanceof PassiveRackElement) {
            StringBuilder sb = new StringBuilder();
            PassiveRackElement el = (PassiveRackElement)this.object;
            sb.append(el.toString());
            CLabel infoText = new CLabel(dialogArea, 2);
            infoText.setText(sb.toString());
        }
        return dialogArea;
    }

    protected List<Control> getForegroundColorExclusions() {
        List e = super.getForegroundColorExclusions();
        e.add(this.statusLabel);
        return e;
    }

    private static String getObjectDisplayName(Object object) {
        if (object instanceof AbstractObject) {
            return ((AbstractObject)object).getObjectName();
        }
        if (object instanceof PassiveRackElement) {
            return ((PassiveRackElement)object).getType().toString();
        }
        return object.toString();
    }

    private static void createSeparator(Composite parent) {
        Label separator = new Label(parent, 258);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)separator);
    }

    private static void appendText(StringBuilder sb, String text) {
        if (text == null || text.isEmpty()) {
            return;
        }
        sb.append(text);
        sb.append('\n');
    }
}

