/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.widgets;

import java.net.Inet4Address;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.Subnet;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.tools.ColorCache;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class SubnetAddressMap
extends Canvas
implements PaintListener,
MouseTrackListener {
    private static final int HORIZONTAL_MARGIN = 20;
    private static final int VERTICAL_MARGIN = 10;
    private static final int HORIZONTAL_SPACING = 10;
    private static final int VERTICAL_SPACING = 10;
    private static final int ELEMENT_WIDTH = 70;
    private static final int ELEMENT_HEIGHT = 25;
    private static final int ELEMENTS_PER_ROW = 16;
    private static final int MAX_ROWS = 256;
    private static final RGB COLOR_RESERVED = new RGB(224, 224, 224);
    private static final RGB COLOR_USED = new RGB(237, 24, 35);
    private static final RGB COLOR_FREE = new RGB(0, 220, 55);
    private final I18n i18n = LocalizationHelper.getI18n(SubnetAddressMap.class);
    private NXCSession session = Registry.getSession();
    private ObjectView view;
    private long[] addressMap = null;
    private Subnet subnet = null;
    private int rowCount = 0;
    private ColorCache colors;
    private Runnable updateListener;

    public SubnetAddressMap(Composite parent, int style, ObjectView view) {
        super(parent, style | 0x20000000);
        this.view = view;
        this.colors = new ColorCache((Control)this);
        this.addPaintListener((PaintListener)this);
        WidgetHelper.attachMouseTrackListener((Composite)this, (MouseTrackListener)this);
    }

    public void dispose() {
        this.removePaintListener((PaintListener)this);
        super.dispose();
    }

    public Runnable getUpdateListener() {
        return this.updateListener;
    }

    public void setUpdateListener(Runnable updateListener) {
        this.updateListener = updateListener;
    }

    public void setSubnet(Subnet subnet) {
        this.subnet = subnet;
        if (subnet != null && subnet.getSubnetAddress() instanceof Inet4Address) {
            this.rowCount = ((1 << 32 - subnet.getSubnetMask()) + 16 - 1) / 16;
            if (this.rowCount > 256) {
                this.rowCount = 256;
            }
        } else {
            this.rowCount = 0;
            this.subnet = null;
        }
        this.refresh();
    }

    public void refresh() {
        if (this.subnet == null) {
            this.addressMap = null;
            this.rowCount = 0;
            this.redraw();
            if (this.updateListener != null) {
                this.updateListener.run();
            }
            return;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private int getElementFromPoint(int x, int y) {
        int xOffset = 20;
        if (x < 20 || y < 10) {
            return -1;
        }
        int column = (x - 20) / 80;
        if (column >= 16) {
            return -1;
        }
        if (x > 20 + column * 80 + 70) {
            return -1;
        }
        int row = (y - 10) / 35;
        if (row >= this.rowCount) {
            return -1;
        }
        if (y > 10 + row * 35 + 25) {
            return -1;
        }
        return row * 16 + column;
    }

    public void paintControl(PaintEvent e) {
        if (this.addressMap == null) {
            return;
        }
        int x = 20;
        int y = 10;
        int row = 0;
        int column = 0;
        byte[] address = this.subnet.getSubnetAddress().getAddress();
        for (int i = 0; i < this.addressMap.length; ++i) {
            this.drawAddress(address, this.addressMap[i], x, y, e.gc);
            if (++column == 16) {
                if (++row >= 256) break;
                column = 0;
                x = 20;
                y += 35;
            } else {
                x += 80;
            }
            if (address[address.length - 1] != -1) {
                int n = address.length - 1;
                address[n] = (byte)(address[n] + 1);
                continue;
            }
            int n = address.length - 2;
            address[n] = (byte)(address[n] + 1);
            address[address.length - 1] = 0;
        }
    }

    private void drawAddress(byte[] address, long nodeId, int x, int y, GC gc) {
        String label = this.subnet.getSubnetMask() < 24 ? "." + (address[address.length - 2] & 0xFF) + "." + (address[address.length - 1] & 0xFF) : "." + (address[address.length - 1] & 0xFF);
        Rectangle rect = new Rectangle(x, y, 70, 25);
        if (nodeId == 0L) {
            gc.setBackground(this.colors.create(COLOR_FREE));
        } else if (nodeId == 0xFFFFFFFFL) {
            gc.setBackground(this.colors.create(COLOR_RESERVED));
        } else {
            gc.setBackground(this.colors.create(COLOR_USED));
        }
        gc.fillRectangle(rect);
        gc.drawRectangle(rect);
        Point ext = gc.textExtent(label);
        gc.drawText(label, x + (70 - ext.x) / 2, y + (25 - ext.y) / 2);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return new Point(1310, this.rowCount * 25 + (this.rowCount - 1) * 10 + 20);
    }

    public void mouseEnter(MouseEvent e) {
    }

    public void mouseExit(MouseEvent e) {
    }

    public void mouseHover(MouseEvent e) {
        int index = this.getElementFromPoint(e.x, e.y);
        if (index == -1) {
            this.setToolTipText(null);
        } else if (index == 0 && !this.subnet.isPointToPoint()) {
            this.setToolTipText(this.i18n.tr("Subnet address"));
        } else if (index == this.addressMap.length - 1 && !this.subnet.isPointToPoint()) {
            this.setToolTipText(this.i18n.tr("Broadcast address"));
        } else if (this.addressMap[index] == 0L) {
            this.setToolTipText(this.i18n.tr("Free"));
        } else {
            AbstractNode node = (AbstractNode)this.session.findObjectById(this.addressMap[index], AbstractNode.class);
            if (node != null) {
                this.setToolTipText(node.getObjectName());
            } else {
                this.setToolTipText("[" + this.addressMap[index] + "]");
            }
        }
    }
}

