/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.serverconfig.views.helpers;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.netxms.client.NXCSession;
import org.netxms.client.ScheduledTask;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.SortableTableViewer;

public class ScheduledTaskComparator
extends ViewerComparator {
    private NXCSession session = Registry.getSession();

    public int compare(Viewer viewer, Object e1, Object e2) {
        int result;
        ScheduledTask task1 = (ScheduledTask)e1;
        ScheduledTask task2 = (ScheduledTask)e2;
        switch ((Integer)((SortableTableViewer)viewer).getTable().getSortColumn().getData("ID")) {
            case 0: {
                result = (int)(task1.getId() - task2.getId());
                break;
            }
            case 1: {
                result = task1.getTaskHandlerId().compareToIgnoreCase(task2.getTaskHandlerId());
                break;
            }
            case 2: {
                AbstractObject obj1 = this.session.findObjectById(task1.getObjectId());
                AbstractObject obj2 = this.session.findObjectById(task2.getObjectId());
                String name1 = obj1 != null ? obj1.getObjectName() : "";
                String name2 = obj2 != null ? obj2.getObjectName() : "";
                result = name1.compareToIgnoreCase(name2);
                break;
            }
            case 3: {
                result = task1.getParameters().compareToIgnoreCase(task2.getParameters());
                break;
            }
            case 5: {
                if (task1.getSchedule().isEmpty()) {
                    if (task2.getSchedule().isEmpty()) {
                        result = task1.getExecutionTime().compareTo(task2.getExecutionTime());
                        break;
                    }
                    result = 1;
                    break;
                }
                if (task2.getSchedule().isEmpty()) {
                    result = -1;
                }
                result = task1.getSchedule().compareToIgnoreCase(task2.getSchedule());
                break;
            }
            case 7: {
                result = task1.getLastExecutionTime().compareTo(task2.getLastExecutionTime());
                break;
            }
            case 8: {
                result = task1.getStatus().compareToIgnoreCase(task2.getStatus());
                break;
            }
            case 10: {
                AbstractUserObject user;
                String user1 = "";
                Object user2 = "";
                if (task1.isSystem()) {
                    user1 = "system";
                } else {
                    user = this.session.findUserDBObjectById(task1.getOwner(), null);
                    String string = user1 = user != null ? user.getName() : "[" + Long.toString(task1.getOwner()) + "]";
                }
                user2 = task2.isSystem() ? "system" : ((user = this.session.findUserDBObjectById(task2.getOwner(), null)) != null ? user.getName() : "[" + Long.toString(task1.getOwner()) + "]");
                result = user1.compareTo((String)user2);
                break;
            }
            case 11: {
                result = task1.getComments().compareToIgnoreCase(task2.getComments());
                break;
            }
            case 4: {
                result = task1.getKey().compareToIgnoreCase(task2.getKey());
                break;
            }
            default: {
                result = 0;
            }
        }
        return ((SortableTableViewer)viewer).getTable().getSortDirection() == 128 ? result : -result;
    }
}

